/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoralBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockCoralPlant
extends BlockCoralBase {
    private final Block deadBlock;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 15.0, 14.0);

    protected BlockCoralPlant(Block var0, BlockBase.Info var1) {
        super(var1);
        this.deadBlock = var0;
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        this.tryScheduleDieTick(var0, var1, var2);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!BlockCoralPlant.scanForWater(var0, var1, var2)) {
            var1.setBlock(var2, (IBlockData)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false), 2);
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        this.tryScheduleDieTick(var0, var3, var4);
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }
}

