/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;

public abstract class WorldChunkManager
implements BiomeResolver {
    public static final Codec<WorldChunkManager> CODEC = IRegistry.BIOME_SOURCE.byNameCodec().dispatchStable(WorldChunkManager::codec, Function.identity());
    private final Set<Holder<BiomeBase>> possibleBiomes;

    protected WorldChunkManager(Stream<Holder<BiomeBase>> var0) {
        this(var0.distinct().toList());
    }

    protected WorldChunkManager(List<Holder<BiomeBase>> var0) {
        this.possibleBiomes = new ObjectLinkedOpenHashSet(var0);
    }

    protected abstract Codec<? extends WorldChunkManager> codec();

    public Set<Holder<BiomeBase>> possibleBiomes() {
        return this.possibleBiomes;
    }

    public Set<Holder<BiomeBase>> getBiomesWithin(int var0, int var1, int var2, int var3, Climate.Sampler var4) {
        int var5 = QuartPos.fromBlock(var0 - var3);
        int var6 = QuartPos.fromBlock(var1 - var3);
        int var7 = QuartPos.fromBlock(var2 - var3);
        int var8 = QuartPos.fromBlock(var0 + var3);
        int var9 = QuartPos.fromBlock(var1 + var3);
        int var10 = QuartPos.fromBlock(var2 + var3);
        int var11 = var8 - var5 + 1;
        int var12 = var9 - var6 + 1;
        int var13 = var10 - var7 + 1;
        HashSet var14 = Sets.newHashSet();
        for (int var15 = 0; var15 < var13; ++var15) {
            for (int var16 = 0; var16 < var11; ++var16) {
                for (int var17 = 0; var17 < var12; ++var17) {
                    int var18 = var5 + var16;
                    int var19 = var6 + var17;
                    int var20 = var7 + var15;
                    var14.add(this.getNoiseBiome(var18, var19, var20, var4));
                }
            }
        }
        return var14;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findBiomeHorizontal(int var0, int var1, int var2, int var3, Predicate<Holder<BiomeBase>> var4, RandomSource var5, Climate.Sampler var6) {
        return this.findBiomeHorizontal(var0, var1, var2, var3, 1, var4, var5, false, var6);
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findClosestBiome3d(BlockPosition var0, int var1, int var2, int var3, Predicate<Holder<BiomeBase>> var4, Climate.Sampler var5, IWorldReader var6) {
        Set var7 = this.possibleBiomes().stream().filter(var4).collect(Collectors.toUnmodifiableSet());
        if (var7.isEmpty()) {
            return null;
        }
        int var8 = Math.floorDiv(var1, var2);
        int[] var9 = MathHelper.outFromOrigin(var0.getY(), var6.getMinBuildHeight() + 1, var6.getMaxBuildHeight(), var3).toArray();
        for (BlockPosition.MutableBlockPosition var11 : BlockPosition.spiralAround(BlockPosition.ZERO, var8, EnumDirection.EAST, EnumDirection.SOUTH)) {
            int var12 = var0.getX() + var11.getX() * var2;
            int var13 = var0.getZ() + var11.getZ() * var2;
            int var14 = QuartPos.fromBlock(var12);
            int var15 = QuartPos.fromBlock(var13);
            for (int var19 : var9) {
                int var20 = QuartPos.fromBlock(var19);
                Holder<BiomeBase> var21 = this.getNoiseBiome(var14, var20, var15, var5);
                if (!var7.contains(var21)) continue;
                return Pair.of((Object)new BlockPosition(var12, var19, var13), var21);
            }
        }
        return null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findBiomeHorizontal(int var0, int var1, int var2, int var3, int var4, Predicate<Holder<BiomeBase>> var5, RandomSource var6, boolean var7, Climate.Sampler var8) {
        int var15;
        int var9 = QuartPos.fromBlock(var0);
        int var10 = QuartPos.fromBlock(var2);
        int var11 = QuartPos.fromBlock(var3);
        int var12 = QuartPos.fromBlock(var1);
        Pair var13 = null;
        int var14 = 0;
        for (int var16 = var15 = var7 ? 0 : var11; var16 <= var11; var16 += var4) {
            int var17;
            int n2 = var17 = SharedConstants.debugGenerateSquareTerrainWithoutNoise ? 0 : -var16;
            while (var17 <= var16) {
                boolean var18 = Math.abs(var17) == var16;
                for (int var19 = -var16; var19 <= var16; var19 += var4) {
                    int var21;
                    Holder<BiomeBase> var22;
                    int var20;
                    if (var7) {
                        int n3 = var20 = Math.abs(var19) == var16 ? 1 : 0;
                        if (var20 == 0 && !var18) continue;
                    }
                    if (!var5.test(var22 = this.getNoiseBiome(var20 = var9 + var19, var12, var21 = var10 + var17, var8))) continue;
                    if (var13 == null || var6.nextInt(var14 + 1) == 0) {
                        BlockPosition var23 = new BlockPosition(QuartPos.toBlock(var20), var1, QuartPos.toBlock(var21));
                        if (var7) {
                            return Pair.of((Object)var23, var22);
                        }
                        var13 = Pair.of((Object)var23, var22);
                    }
                    ++var14;
                }
                var17 += var4;
            }
        }
        return var13;
    }

    @Override
    public abstract Holder<BiomeBase> getNoiseBiome(int var1, int var2, int var3, Climate.Sampler var4);

    public void addDebugInfo(List<String> var0, BlockPosition var1, Climate.Sampler var2) {
    }
}

