/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.util.INamable;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import org.slf4j.Logger;

public class BiomeSettingsMobs {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float DEFAULT_CREATURE_SPAWN_PROBABILITY = 0.1f;
    public static final WeightedRandomList<c> EMPTY_MOB_LIST = WeightedRandomList.create();
    public static final BiomeSettingsMobs EMPTY = new a().build();
    public static final MapCodec<BiomeSettingsMobs> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.floatRange((float)0.0f, (float)0.9999999f).optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(var0 -> Float.valueOf(var0.creatureGenerationProbability)), (App)Codec.simpleMap(EnumCreatureType.CODEC, (Codec)WeightedRandomList.codec(c.CODEC).promotePartial(SystemUtils.prefix("Spawn data: ", arg_0 -> ((Logger)LOGGER).error(arg_0))), (Keyable)INamable.keys(EnumCreatureType.values())).fieldOf("spawners").forGetter(var0 -> var0.spawners), (App)Codec.simpleMap(IRegistry.ENTITY_TYPE.byNameCodec(), b.CODEC, IRegistry.ENTITY_TYPE).fieldOf("spawn_costs").forGetter(var0 -> var0.mobSpawnCosts)).apply((Applicative)var02, BiomeSettingsMobs::new));
    private final float creatureGenerationProbability;
    private final Map<EnumCreatureType, WeightedRandomList<c>> spawners;
    private final Map<EntityTypes<?>, b> mobSpawnCosts;

    BiomeSettingsMobs(float var0, Map<EnumCreatureType, WeightedRandomList<c>> var1, Map<EntityTypes<?>, b> var2) {
        this.creatureGenerationProbability = var0;
        this.spawners = ImmutableMap.copyOf(var1);
        this.mobSpawnCosts = ImmutableMap.copyOf(var2);
    }

    public WeightedRandomList<c> getMobs(EnumCreatureType var0) {
        return this.spawners.getOrDefault(var0, EMPTY_MOB_LIST);
    }

    @Nullable
    public b getMobSpawnCost(EntityTypes<?> var0) {
        return this.mobSpawnCosts.get(var0);
    }

    public float getCreatureProbability() {
        return this.creatureGenerationProbability;
    }

    public static class b {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(var0 -> var0.energyBudget), (App)Codec.DOUBLE.fieldOf("charge").forGetter(var0 -> var0.charge)).apply((Applicative)var02, b::new));
        private final double energyBudget;
        private final double charge;

        b(double var0, double var2) {
            this.energyBudget = var0;
            this.charge = var2;
        }

        public double getEnergyBudget() {
            return this.energyBudget;
        }

        public double getCharge() {
            return this.charge;
        }
    }

    public static class c
    extends WeightedEntry.a {
        public static final Codec<c> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)IRegistry.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(var0 -> var0.type), (App)Weight.CODEC.fieldOf("weight").forGetter(WeightedEntry.a::getWeight), (App)Codec.INT.fieldOf("minCount").forGetter(var0 -> var0.minCount), (App)Codec.INT.fieldOf("maxCount").forGetter(var0 -> var0.maxCount)).apply((Applicative)var02, c::new));
        public final EntityTypes<?> type;
        public final int minCount;
        public final int maxCount;

        public c(EntityTypes<?> var0, int var1, int var2, int var3) {
            this(var0, Weight.of(var1), var2, var3);
        }

        public c(EntityTypes<?> var0, Weight var1, int var2, int var3) {
            super(var1);
            this.type = var0.getCategory() == EnumCreatureType.MISC ? EntityTypes.PIG : var0;
            this.minCount = var2;
            this.maxCount = var3;
        }

        public String toString() {
            return EntityTypes.getKey(this.type) + "*(" + this.minCount + "-" + this.maxCount + "):" + this.getWeight();
        }
    }

    public static class a {
        private final Map<EnumCreatureType, List<c>> spawners = (Map)Stream.of(EnumCreatureType.values()).collect(ImmutableMap.toImmutableMap(var0 -> var0, var0 -> Lists.newArrayList()));
        private final Map<EntityTypes<?>, b> mobSpawnCosts = Maps.newLinkedHashMap();
        private float creatureGenerationProbability = 0.1f;

        public a addSpawn(EnumCreatureType var0, c var1) {
            this.spawners.get(var0).add(var1);
            return this;
        }

        public a addMobCharge(EntityTypes<?> var0, double var1, double var3) {
            this.mobSpawnCosts.put(var0, new b(var3, var1));
            return this;
        }

        public a creatureGenerationProbability(float var0) {
            this.creatureGenerationProbability = var0;
            return this;
        }

        public BiomeSettingsMobs build() {
            return new BiomeSettingsMobs(this.creatureGenerationProbability, (Map)this.spawners.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> WeightedRandomList.create((List)var0.getValue()))), (Map<EntityTypes<?>, b>)ImmutableMap.copyOf(this.mobSpawnCosts));
        }
    }
}

