/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.EnchantmentSlotType;
import net.minecraft.world.item.enchantment.Enchantments;

public class EnchantmentProtection
extends Enchantment {
    public final DamageType type;

    public EnchantmentProtection(Enchantment.Rarity var0, DamageType var1, EnumItemSlot ... var2) {
        super(var0, var1 == DamageType.FALL ? EnchantmentSlotType.ARMOR_FEET : EnchantmentSlotType.ARMOR, var2);
        this.type = var1;
    }

    @Override
    public int getMinCost(int var0) {
        return this.type.getMinCost() + (var0 - 1) * this.type.getLevelCost();
    }

    @Override
    public int getMaxCost(int var0) {
        return this.getMinCost(var0) + this.type.getLevelCost();
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getDamageProtection(int var0, DamageSource var1) {
        if (var1.isBypassInvul()) {
            return 0;
        }
        if (this.type == DamageType.ALL) {
            return var0;
        }
        if (this.type == DamageType.FIRE && var1.isFire()) {
            return var0 * 2;
        }
        if (this.type == DamageType.FALL && var1.isFall()) {
            return var0 * 3;
        }
        if (this.type == DamageType.EXPLOSION && var1.isExplosion()) {
            return var0 * 2;
        }
        if (this.type == DamageType.PROJECTILE && var1.isProjectile()) {
            return var0 * 2;
        }
        return 0;
    }

    @Override
    public boolean checkCompatibility(Enchantment var0) {
        if (var0 instanceof EnchantmentProtection) {
            EnchantmentProtection var1 = (EnchantmentProtection)var0;
            if (this.type == var1.type) {
                return false;
            }
            return this.type == DamageType.FALL || var1.type == DamageType.FALL;
        }
        return super.checkCompatibility(var0);
    }

    public static int getFireAfterDampener(EntityLiving var0, int var1) {
        int var2 = EnchantmentManager.getEnchantmentLevel(Enchantments.FIRE_PROTECTION, var0);
        if (var2 > 0) {
            var1 -= MathHelper.floor((float)var1 * ((float)var2 * 0.15f));
        }
        return var1;
    }

    public static double getExplosionKnockbackAfterDampener(EntityLiving var0, double var1) {
        int var3 = EnchantmentManager.getEnchantmentLevel(Enchantments.BLAST_PROTECTION, var0);
        if (var3 > 0) {
            var1 -= (double)MathHelper.floor(var1 * (double)((float)var3 * 0.15f));
        }
        return var1;
    }

    public static final class DamageType
    extends Enum<DamageType> {
        public static final /* enum */ DamageType ALL = new DamageType(1, 11);
        public static final /* enum */ DamageType FIRE = new DamageType(10, 8);
        public static final /* enum */ DamageType FALL = new DamageType(5, 6);
        public static final /* enum */ DamageType EXPLOSION = new DamageType(5, 8);
        public static final /* enum */ DamageType PROJECTILE = new DamageType(3, 6);
        private final int minCost;
        private final int levelCost;
        private static final /* synthetic */ DamageType[] h;

        public static DamageType[] values() {
            return (DamageType[])h.clone();
        }

        public static DamageType valueOf(String var0) {
            return Enum.valueOf(DamageType.class, var0);
        }

        private DamageType(int var2, int var3) {
            this.minCost = var2;
            this.levelCost = var3;
        }

        public int getMinCost() {
            return this.minCost;
        }

        public int getLevelCost() {
            return this.levelCost;
        }

        private static /* synthetic */ DamageType[] c() {
            return new DamageType[]{ALL, FIRE, FALL, EXPLOSION, PROJECTILE};
        }

        static {
            h = DamageType.c();
        }
    }
}

