/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.context;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class BlockActionContext
extends ItemActionContext {
    private final BlockPosition relativePos;
    protected boolean replaceClicked = true;

    public BlockActionContext(EntityHuman var0, EnumHand var1, ItemStack var2, MovingObjectPositionBlock var3) {
        this(var0.level, var0, var1, var2, var3);
    }

    public BlockActionContext(ItemActionContext var0) {
        this(var0.getLevel(), var0.getPlayer(), var0.getHand(), var0.getItemInHand(), var0.getHitResult());
    }

    protected BlockActionContext(World var0, @Nullable EntityHuman var1, EnumHand var2, ItemStack var3, MovingObjectPositionBlock var4) {
        super(var0, var1, var2, var3, var4);
        this.relativePos = var4.getBlockPos().relative(var4.getDirection());
        this.replaceClicked = var0.getBlockState(var4.getBlockPos()).canBeReplaced(this);
    }

    public static BlockActionContext at(BlockActionContext var0, BlockPosition var1, EnumDirection var2) {
        return new BlockActionContext(var0.getLevel(), var0.getPlayer(), var0.getHand(), var0.getItemInHand(), new MovingObjectPositionBlock(new Vec3D((double)var1.getX() + 0.5 + (double)var2.getStepX() * 0.5, (double)var1.getY() + 0.5 + (double)var2.getStepY() * 0.5, (double)var1.getZ() + 0.5 + (double)var2.getStepZ() * 0.5), var2, var1, false));
    }

    @Override
    public BlockPosition getClickedPos() {
        return this.replaceClicked ? super.getClickedPos() : this.relativePos;
    }

    public boolean canPlace() {
        return this.replaceClicked || this.getLevel().getBlockState(this.getClickedPos()).canBeReplaced(this);
    }

    public boolean replacingClickedOnBlock() {
        return this.replaceClicked;
    }

    public EnumDirection getNearestLookingDirection() {
        return EnumDirection.orderedByNearest(this.getPlayer())[0];
    }

    public EnumDirection getNearestLookingVerticalDirection() {
        return EnumDirection.getFacingAxis(this.getPlayer(), EnumDirection.EnumAxis.Y);
    }

    public EnumDirection[] getNearestLookingDirections() {
        int var2;
        EnumDirection[] var0 = EnumDirection.orderedByNearest(this.getPlayer());
        if (this.replaceClicked) {
            return var0;
        }
        EnumDirection var1 = this.getClickedFace();
        for (var2 = 0; var2 < var0.length && var0[var2] != var1.getOpposite(); ++var2) {
        }
        if (var2 > 0) {
            System.arraycopy(var0, 0, var0, 1, var2);
            var0[0] = var1.getOpposite();
        }
        return var0;
    }
}

