/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class DismountUtil {
    public static int[][] offsetsForDirection(EnumDirection var0) {
        EnumDirection var1 = var0.getClockWise();
        EnumDirection var2 = var1.getOpposite();
        EnumDirection var3 = var0.getOpposite();
        return new int[][]{{var1.getStepX(), var1.getStepZ()}, {var2.getStepX(), var2.getStepZ()}, {var3.getStepX() + var1.getStepX(), var3.getStepZ() + var1.getStepZ()}, {var3.getStepX() + var2.getStepX(), var3.getStepZ() + var2.getStepZ()}, {var0.getStepX() + var1.getStepX(), var0.getStepZ() + var1.getStepZ()}, {var0.getStepX() + var2.getStepX(), var0.getStepZ() + var2.getStepZ()}, {var3.getStepX(), var3.getStepZ()}, {var0.getStepX(), var0.getStepZ()}};
    }

    public static boolean isBlockFloorValid(double var0) {
        return !Double.isInfinite(var0) && var0 < 1.0;
    }

    public static boolean canDismountTo(ICollisionAccess var0, EntityLiving var1, AxisAlignedBB var2) {
        Iterable<VoxelShape> var3 = var0.getBlockCollisions(var1, var2);
        for (VoxelShape var5 : var3) {
            if (var5.isEmpty()) continue;
            return false;
        }
        return var0.getWorldBorder().isWithinBounds(var2);
    }

    public static boolean canDismountTo(ICollisionAccess var0, Vec3D var1, EntityLiving var2, EntityPose var3) {
        return DismountUtil.canDismountTo(var0, var2, var2.getLocalBoundsForPose(var3).move(var1));
    }

    public static VoxelShape nonClimbableShape(IBlockAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        if (var2.is(TagsBlock.CLIMBABLE) || var2.getBlock() instanceof BlockTrapdoor && var2.getValue(BlockTrapdoor.OPEN).booleanValue()) {
            return VoxelShapes.empty();
        }
        return var2.getCollisionShape(var0, var1);
    }

    public static double findCeilingFrom(BlockPosition var0, int var1, Function<BlockPosition, VoxelShape> var2) {
        BlockPosition.MutableBlockPosition var3 = var0.mutable();
        for (int var4 = 0; var4 < var1; ++var4) {
            VoxelShape var5 = var2.apply(var3);
            if (!var5.isEmpty()) {
                return (double)(var0.getY() + var4) + var5.min(EnumDirection.EnumAxis.Y);
            }
            var3.move(EnumDirection.UP);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Nullable
    public static Vec3D findSafeDismountLocation(EntityTypes<?> var0, ICollisionAccess var1, BlockPosition var2, boolean var3) {
        if (var3 && var0.isBlockDangerous(var1.getBlockState(var2))) {
            return null;
        }
        double var4 = var1.getBlockFloorHeight(DismountUtil.nonClimbableShape(var1, var2), () -> DismountUtil.nonClimbableShape(var1, var2.below()));
        if (!DismountUtil.isBlockFloorValid(var4)) {
            return null;
        }
        if (var3 && var4 <= 0.0 && var0.isBlockDangerous(var1.getBlockState(var2.below()))) {
            return null;
        }
        Vec3D var6 = Vec3D.upFromBottomCenterOf(var2, var4);
        AxisAlignedBB var7 = var0.getDimensions().makeBoundingBox(var6);
        Iterable<VoxelShape> var8 = var1.getBlockCollisions(null, var7);
        for (VoxelShape var10 : var8) {
            if (var10.isEmpty()) continue;
            return null;
        }
        if (!var1.getWorldBorder().isWithinBounds(var7)) {
            return null;
        }
        return var6;
    }
}

