/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> DATA_ID_FIREWORKS_ITEM = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.ITEM_STACK);
    private static final DataWatcherObject<OptionalInt> DATA_ATTACHED_TO_TARGET = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.OPTIONAL_UNSIGNED_INT);
    public static final DataWatcherObject<Boolean> DATA_SHOT_AT_ANGLE = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.BOOLEAN);
    private int life;
    public int lifetime;
    @Nullable
    private EntityLiving attachedToEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    public EntityFireworks(World var0, double var1, double var3, double var5, ItemStack var7) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.FIREWORK_ROCKET, var0);
        this.life = 0;
        this.setPos(var1, var3, var5);
        int var8 = 1;
        if (!var7.isEmpty() && var7.hasTag()) {
            this.entityData.set(DATA_ID_FIREWORKS_ITEM, var7.copy());
            var8 += var7.getOrCreateTagElement("Fireworks").getByte("Flight");
        }
        this.setDeltaMovement(this.random.triangle(0.0, 0.002297), 0.05, this.random.triangle(0.0, 0.002297));
        this.lifetime = 10 * var8 + this.random.nextInt(6) + this.random.nextInt(7);
    }

    public EntityFireworks(World var0, @Nullable Entity var1, double var2, double var4, double var6, ItemStack var8) {
        this(var0, var2, var4, var6, var8);
        this.setOwner(var1);
    }

    public EntityFireworks(World var0, ItemStack var1, EntityLiving var2) {
        this(var0, var2, var2.getX(), var2.getY(), var2.getZ(), var1);
        this.entityData.set(DATA_ATTACHED_TO_TARGET, OptionalInt.of(var2.getId()));
        this.attachedToEntity = var2;
    }

    public EntityFireworks(World var0, ItemStack var1, double var2, double var4, double var6, boolean var8) {
        this(var0, var2, var4, var6, var1);
        this.entityData.set(DATA_SHOT_AT_ANGLE, var8);
    }

    public EntityFireworks(World var0, ItemStack var1, Entity var2, double var3, double var5, double var7, boolean var9) {
        this(var0, var1, var3, var5, var7, var9);
        this.setOwner(var2);
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_ID_FIREWORKS_ITEM, ItemStack.EMPTY);
        this.entityData.define(DATA_ATTACHED_TO_TARGET, OptionalInt.empty());
        this.entityData.define(DATA_SHOT_AT_ANGLE, false);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return var0 < 4096.0 && !this.isAttachedToEntity();
    }

    @Override
    public boolean shouldRender(double var0, double var2, double var4) {
        return super.shouldRender(var0, var2, var4) && !this.isAttachedToEntity();
    }

    @Override
    public void tick() {
        Object var02;
        super.tick();
        if (this.isAttachedToEntity()) {
            if (this.attachedToEntity == null) {
                this.entityData.get(DATA_ATTACHED_TO_TARGET).ifPresent(var0 -> {
                    Entity var1 = this.level.getEntity(var0);
                    if (var1 instanceof EntityLiving) {
                        this.attachedToEntity = (EntityLiving)var1;
                    }
                });
            }
            if (this.attachedToEntity != null) {
                if (this.attachedToEntity.isFallFlying()) {
                    Vec3D var1 = this.attachedToEntity.getLookAngle();
                    double var2 = 1.5;
                    double var4 = 0.1;
                    Vec3D var6 = this.attachedToEntity.getDeltaMovement();
                    this.attachedToEntity.setDeltaMovement(var6.add(var1.x * 0.1 + (var1.x * 1.5 - var6.x) * 0.5, var1.y * 0.1 + (var1.y * 1.5 - var6.y) * 0.5, var1.z * 0.1 + (var1.z * 1.5 - var6.z) * 0.5));
                    var02 = this.attachedToEntity.getHandHoldingItemAngle(Items.FIREWORK_ROCKET);
                } else {
                    var02 = Vec3D.ZERO;
                }
                this.setPos(this.attachedToEntity.getX() + ((Vec3D)var02).x, this.attachedToEntity.getY() + ((Vec3D)var02).y, this.attachedToEntity.getZ() + ((Vec3D)var02).z);
                this.setDeltaMovement(this.attachedToEntity.getDeltaMovement());
            }
        } else {
            if (!this.isShotAtAngle()) {
                double var03 = this.horizontalCollision ? 1.0 : 1.15;
                this.setDeltaMovement(this.getDeltaMovement().multiply(var03, 1.0, var03).add(0.0, 0.04, 0.0));
            }
            var02 = this.getDeltaMovement();
            this.move(EnumMoveType.SELF, (Vec3D)var02);
            this.setDeltaMovement((Vec3D)var02);
        }
        var02 = ProjectileHelper.getHitResult(this, this::canHitEntity);
        if (!this.noPhysics) {
            this.onHit((MovingObjectPosition)var02);
            this.hasImpulse = true;
        }
        this.updateRotation();
        if (this.life == 0 && !this.isSilent()) {
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.FIREWORK_ROCKET_LAUNCH, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.life;
        if (this.level.isClientSide && this.life % 2 < 2) {
            this.level.addParticle(Particles.FIREWORK, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
        if (!this.level.isClientSide && this.life > this.lifetime) {
            this.explode();
        }
    }

    private void explode() {
        this.level.broadcastEntityEvent(this, (byte)17);
        this.gameEvent(GameEvent.EXPLODE, this.getOwner());
        this.dealExplosionDamage();
        this.discard();
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        if (this.level.isClientSide) {
            return;
        }
        this.explode();
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        BlockPosition var1 = new BlockPosition(var0.getBlockPos());
        this.level.getBlockState(var1).entityInside(this.level, var1, this);
        if (!this.level.isClientSide() && this.hasExplosion()) {
            this.explode();
        }
        super.onHitBlock(var0);
    }

    private boolean hasExplosion() {
        ItemStack var0 = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
        NBTTagCompound var1 = var0.isEmpty() ? null : var0.getTagElement("Fireworks");
        NBTTagList var2 = var1 != null ? var1.getList("Explosions", 10) : null;
        return var2 != null && !var2.isEmpty();
    }

    private void dealExplosionDamage() {
        NBTTagList var3;
        float var0 = 0.0f;
        ItemStack var1 = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
        NBTTagCompound var2 = var1.isEmpty() ? null : var1.getTagElement("Fireworks");
        NBTTagList nBTTagList = var3 = var2 != null ? var2.getList("Explosions", 10) : null;
        if (var3 != null && !var3.isEmpty()) {
            var0 = 5.0f + (float)(var3.size() * 2);
        }
        if (var0 > 0.0f) {
            if (this.attachedToEntity != null) {
                this.attachedToEntity.hurt(DamageSource.fireworks(this, this.getOwner()), 5.0f + (float)(var3.size() * 2));
            }
            double var4 = 5.0;
            Vec3D var6 = this.position();
            List<EntityLiving> var7 = this.level.getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(5.0));
            for (EntityLiving var9 : var7) {
                if (var9 == this.attachedToEntity || this.distanceToSqr(var9) > 25.0) continue;
                boolean var10 = false;
                for (int var11 = 0; var11 < 2; ++var11) {
                    Vec3D var12 = new Vec3D(var9.getX(), var9.getY(0.5 * (double)var11), var9.getZ());
                    MovingObjectPositionBlock var13 = this.level.clip(new RayTrace(var6, var12, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this));
                    if (((MovingObjectPosition)var13).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) continue;
                    var10 = true;
                    break;
                }
                if (!var10) continue;
                float var11 = var0 * (float)Math.sqrt((5.0 - (double)this.distanceTo(var9)) / 5.0);
                var9.hurt(DamageSource.fireworks(this, this.getOwner()), var11);
            }
        }
    }

    private boolean isAttachedToEntity() {
        return this.entityData.get(DATA_ATTACHED_TO_TARGET).isPresent();
    }

    public boolean isShotAtAngle() {
        return this.entityData.get(DATA_SHOT_AT_ANGLE);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 17 && this.level.isClientSide) {
            if (!this.hasExplosion()) {
                for (int var1 = 0; var1 < this.random.nextInt(3) + 2; ++var1) {
                    this.level.addParticle(Particles.POOF, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, 0.005, this.random.nextGaussian() * 0.05);
                }
            } else {
                ItemStack var1 = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
                NBTTagCompound var2 = var1.isEmpty() ? null : var1.getTagElement("Fireworks");
                Vec3D var3 = this.getDeltaMovement();
                this.level.createFireworks(this.getX(), this.getY(), this.getZ(), var3.x, var3.y, var3.z, var2);
            }
        }
        super.handleEntityEvent(var0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Life", this.life);
        var0.putInt("LifeTime", this.lifetime);
        ItemStack var1 = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
        if (!var1.isEmpty()) {
            var0.put("FireworksItem", var1.save(new NBTTagCompound()));
        }
        var0.putBoolean("ShotAtAngle", this.entityData.get(DATA_SHOT_AT_ANGLE));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.life = var0.getInt("Life");
        this.lifetime = var0.getInt("LifeTime");
        ItemStack var1 = ItemStack.of(var0.getCompound("FireworksItem"));
        if (!var1.isEmpty()) {
            this.entityData.set(DATA_ID_FIREWORKS_ITEM, var1);
        }
        if (var0.contains("ShotAtAngle")) {
            this.entityData.set(DATA_SHOT_AT_ANGLE, var0.getBoolean("ShotAtAngle"));
        }
    }

    @Override
    public ItemStack getItem() {
        ItemStack var0 = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
        return var0.isEmpty() ? new ItemStack(Items.FIREWORK_ROCKET) : var0;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }
}

