/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.IDyeable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmorColorable;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class VillagerTrades {
    private static final int DEFAULT_SUPPLY = 12;
    private static final int COMMON_ITEMS_SUPPLY = 16;
    private static final int UNCOMMON_ITEMS_SUPPLY = 3;
    private static final int XP_LEVEL_1_SELL = 1;
    private static final int XP_LEVEL_1_BUY = 2;
    private static final int XP_LEVEL_2_SELL = 5;
    private static final int XP_LEVEL_2_BUY = 10;
    private static final int XP_LEVEL_3_SELL = 10;
    private static final int XP_LEVEL_3_BUY = 20;
    private static final int XP_LEVEL_4_SELL = 15;
    private static final int XP_LEVEL_4_BUY = 30;
    private static final int XP_LEVEL_5_TRADE = 30;
    private static final float LOW_TIER_PRICE_MULTIPLIER = 0.05f;
    private static final float HIGH_TIER_PRICE_MULTIPLIER = 0.2f;
    public static final Map<VillagerProfession, Int2ObjectMap<IMerchantRecipeOption[]>> TRADES = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(VillagerProfession.FARMER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.WHEAT, 20, 16, 2), new b(Items.POTATO, 26, 16, 2), new b(Items.CARROT, 22, 16, 2), new b(Items.BEETROOT, 15, 16, 2), new h(Items.BREAD, 1, 6, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Blocks.PUMPKIN, 6, 12, 10), new h(Items.PUMPKIN_PIE, 1, 4, 5), new h(Items.APPLE, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new h(Items.COOKIE, 3, 18, 10), new b(Blocks.MELON, 4, 12, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new h(Blocks.CAKE, 1, 1, 12, 15), new i(MobEffects.NIGHT_VISION, 100, 15), new i(MobEffects.JUMP, 160, 15), new i(MobEffects.WEAKNESS, 140, 15), new i(MobEffects.BLINDNESS, 120, 15), new i(MobEffects.POISON, 280, 15), new i(MobEffects.SATURATION, 7, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.GOLDEN_CARROT, 3, 3, 30), new h(Items.GLISTERING_MELON_SLICE, 4, 3, 30)})));
        var0.put(VillagerProfession.FISHERMAN, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.STRING, 20, 16, 2), new b(Items.COAL, 10, 16, 2), new g(Items.COD, 6, Items.COOKED_COD, 6, 16, 1), new h(Items.COD_BUCKET, 3, 1, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.COD, 15, 16, 10), new g(Items.SALMON, 6, Items.COOKED_SALMON, 6, 16, 5), new h(Items.CAMPFIRE, 2, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.SALMON, 13, 16, 20), new e(Items.FISHING_ROD, 3, 3, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.TROPICAL_FISH, 6, 12, 30)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.PUFFERFISH, 4, 12, 30), new c(1, 12, 30, (Map<VillagerType, Item>)ImmutableMap.builder().put((Object)VillagerType.PLAINS, (Object)Items.OAK_BOAT).put((Object)VillagerType.TAIGA, (Object)Items.SPRUCE_BOAT).put((Object)VillagerType.SNOW, (Object)Items.SPRUCE_BOAT).put((Object)VillagerType.DESERT, (Object)Items.JUNGLE_BOAT).put((Object)VillagerType.JUNGLE, (Object)Items.JUNGLE_BOAT).put((Object)VillagerType.SAVANNA, (Object)Items.ACACIA_BOAT).put((Object)VillagerType.SWAMP, (Object)Items.DARK_OAK_BOAT).build())})));
        var0.put(VillagerProfession.SHEPHERD, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Blocks.WHITE_WOOL, 18, 16, 2), new b(Blocks.BROWN_WOOL, 18, 16, 2), new b(Blocks.BLACK_WOOL, 18, 16, 2), new b(Blocks.GRAY_WOOL, 18, 16, 2), new h(Items.SHEARS, 2, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.WHITE_DYE, 12, 16, 10), new b(Items.GRAY_DYE, 12, 16, 10), new b(Items.BLACK_DYE, 12, 16, 10), new b(Items.LIGHT_BLUE_DYE, 12, 16, 10), new b(Items.LIME_DYE, 12, 16, 10), new h(Blocks.WHITE_WOOL, 1, 1, 16, 5), new h(Blocks.ORANGE_WOOL, 1, 1, 16, 5), new h(Blocks.MAGENTA_WOOL, 1, 1, 16, 5), new h(Blocks.LIGHT_BLUE_WOOL, 1, 1, 16, 5), new h(Blocks.YELLOW_WOOL, 1, 1, 16, 5), new h(Blocks.LIME_WOOL, 1, 1, 16, 5), new h(Blocks.PINK_WOOL, 1, 1, 16, 5), new h(Blocks.GRAY_WOOL, 1, 1, 16, 5), new h(Blocks.LIGHT_GRAY_WOOL, 1, 1, 16, 5), new h(Blocks.CYAN_WOOL, 1, 1, 16, 5), new h(Blocks.PURPLE_WOOL, 1, 1, 16, 5), new h(Blocks.BLUE_WOOL, 1, 1, 16, 5), new h(Blocks.BROWN_WOOL, 1, 1, 16, 5), new h(Blocks.GREEN_WOOL, 1, 1, 16, 5), new h(Blocks.RED_WOOL, 1, 1, 16, 5), new h(Blocks.BLACK_WOOL, 1, 1, 16, 5), new h(Blocks.WHITE_CARPET, 1, 4, 16, 5), new h(Blocks.ORANGE_CARPET, 1, 4, 16, 5), new h(Blocks.MAGENTA_CARPET, 1, 4, 16, 5), new h(Blocks.LIGHT_BLUE_CARPET, 1, 4, 16, 5), new h(Blocks.YELLOW_CARPET, 1, 4, 16, 5), new h(Blocks.LIME_CARPET, 1, 4, 16, 5), new h(Blocks.PINK_CARPET, 1, 4, 16, 5), new h(Blocks.GRAY_CARPET, 1, 4, 16, 5), new h(Blocks.LIGHT_GRAY_CARPET, 1, 4, 16, 5), new h(Blocks.CYAN_CARPET, 1, 4, 16, 5), new h(Blocks.PURPLE_CARPET, 1, 4, 16, 5), new h(Blocks.BLUE_CARPET, 1, 4, 16, 5), new h(Blocks.BROWN_CARPET, 1, 4, 16, 5), new h(Blocks.GREEN_CARPET, 1, 4, 16, 5), new h(Blocks.RED_CARPET, 1, 4, 16, 5), new h(Blocks.BLACK_CARPET, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.YELLOW_DYE, 12, 16, 20), new b(Items.LIGHT_GRAY_DYE, 12, 16, 20), new b(Items.ORANGE_DYE, 12, 16, 20), new b(Items.RED_DYE, 12, 16, 20), new b(Items.PINK_DYE, 12, 16, 20), new h(Blocks.WHITE_BED, 3, 1, 12, 10), new h(Blocks.YELLOW_BED, 3, 1, 12, 10), new h(Blocks.RED_BED, 3, 1, 12, 10), new h(Blocks.BLACK_BED, 3, 1, 12, 10), new h(Blocks.BLUE_BED, 3, 1, 12, 10), new h(Blocks.BROWN_BED, 3, 1, 12, 10), new h(Blocks.CYAN_BED, 3, 1, 12, 10), new h(Blocks.GRAY_BED, 3, 1, 12, 10), new h(Blocks.GREEN_BED, 3, 1, 12, 10), new h(Blocks.LIGHT_BLUE_BED, 3, 1, 12, 10), new h(Blocks.LIGHT_GRAY_BED, 3, 1, 12, 10), new h(Blocks.LIME_BED, 3, 1, 12, 10), new h(Blocks.MAGENTA_BED, 3, 1, 12, 10), new h(Blocks.ORANGE_BED, 3, 1, 12, 10), new h(Blocks.PINK_BED, 3, 1, 12, 10), new h(Blocks.PURPLE_BED, 3, 1, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.BROWN_DYE, 12, 16, 30), new b(Items.PURPLE_DYE, 12, 16, 30), new b(Items.BLUE_DYE, 12, 16, 30), new b(Items.GREEN_DYE, 12, 16, 30), new b(Items.MAGENTA_DYE, 12, 16, 30), new b(Items.CYAN_DYE, 12, 16, 30), new h(Items.WHITE_BANNER, 3, 1, 12, 15), new h(Items.BLUE_BANNER, 3, 1, 12, 15), new h(Items.LIGHT_BLUE_BANNER, 3, 1, 12, 15), new h(Items.RED_BANNER, 3, 1, 12, 15), new h(Items.PINK_BANNER, 3, 1, 12, 15), new h(Items.GREEN_BANNER, 3, 1, 12, 15), new h(Items.LIME_BANNER, 3, 1, 12, 15), new h(Items.GRAY_BANNER, 3, 1, 12, 15), new h(Items.BLACK_BANNER, 3, 1, 12, 15), new h(Items.PURPLE_BANNER, 3, 1, 12, 15), new h(Items.MAGENTA_BANNER, 3, 1, 12, 15), new h(Items.CYAN_BANNER, 3, 1, 12, 15), new h(Items.BROWN_BANNER, 3, 1, 12, 15), new h(Items.YELLOW_BANNER, 3, 1, 12, 15), new h(Items.ORANGE_BANNER, 3, 1, 12, 15), new h(Items.LIGHT_GRAY_BANNER, 3, 1, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.PAINTING, 2, 3, 30)})));
        var0.put(VillagerProfession.FLETCHER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.STICK, 32, 16, 2), new h(Items.ARROW, 1, 16, 1), new g(Blocks.GRAVEL, 10, Items.FLINT, 10, 12, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.FLINT, 26, 12, 10), new h(Items.BOW, 2, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.STRING, 14, 16, 20), new h(Items.CROSSBOW, 3, 1, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.FEATHER, 24, 16, 30), new e(Items.BOW, 2, 3, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.TRIPWIRE_HOOK, 8, 12, 30), new e(Items.CROSSBOW, 3, 3, 15), new j(Items.ARROW, 5, Items.TIPPED_ARROW, 5, 2, 12, 30)})));
        var0.put(VillagerProfession.LIBRARIAN, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.builder().put((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.PAPER, 24, 16, 2), new d(1), new h(Blocks.BOOKSHELF, 9, 1, 12, 1)}).put((Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.BOOK, 4, 12, 10), new d(5), new h(Items.LANTERN, 1, 1, 5)}).put((Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.INK_SAC, 5, 12, 20), new d(10), new h(Items.GLASS, 1, 4, 10)}).put((Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.WRITABLE_BOOK, 2, 12, 30), new d(15), new h(Items.CLOCK, 5, 1, 15), new h(Items.COMPASS, 4, 1, 15)}).put((Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.NAME_TAG, 20, 1, 30)}).build()));
        var0.put(VillagerProfession.CARTOGRAPHER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.PAPER, 24, 16, 2), new h(Items.MAP, 7, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.GLASS_PANE, 11, 16, 10), new k(13, StructureTags.ON_OCEAN_EXPLORER_MAPS, "filled_map.monument", MapIcon.Type.MONUMENT, 12, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.COMPASS, 1, 12, 20), new k(14, StructureTags.ON_WOODLAND_EXPLORER_MAPS, "filled_map.mansion", MapIcon.Type.MANSION, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new h(Items.ITEM_FRAME, 7, 1, 15), new h(Items.WHITE_BANNER, 3, 1, 15), new h(Items.BLUE_BANNER, 3, 1, 15), new h(Items.LIGHT_BLUE_BANNER, 3, 1, 15), new h(Items.RED_BANNER, 3, 1, 15), new h(Items.PINK_BANNER, 3, 1, 15), new h(Items.GREEN_BANNER, 3, 1, 15), new h(Items.LIME_BANNER, 3, 1, 15), new h(Items.GRAY_BANNER, 3, 1, 15), new h(Items.BLACK_BANNER, 3, 1, 15), new h(Items.PURPLE_BANNER, 3, 1, 15), new h(Items.MAGENTA_BANNER, 3, 1, 15), new h(Items.CYAN_BANNER, 3, 1, 15), new h(Items.BROWN_BANNER, 3, 1, 15), new h(Items.YELLOW_BANNER, 3, 1, 15), new h(Items.ORANGE_BANNER, 3, 1, 15), new h(Items.LIGHT_GRAY_BANNER, 3, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.GLOBE_BANNER_PATTERN, 8, 1, 30)})));
        var0.put(VillagerProfession.CLERIC, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.ROTTEN_FLESH, 32, 16, 2), new h(Items.REDSTONE, 1, 2, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.GOLD_INGOT, 3, 12, 10), new h(Items.LAPIS_LAZULI, 1, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.RABBIT_FOOT, 2, 12, 20), new h(Blocks.GLOWSTONE, 4, 1, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.SCUTE, 4, 12, 30), new b(Items.GLASS_BOTTLE, 9, 12, 30), new h(Items.ENDER_PEARL, 5, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.NETHER_WART, 22, 12, 30), new h(Items.EXPERIENCE_BOTTLE, 3, 1, 30)})));
        var0.put(VillagerProfession.ARMORER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 16, 2), new h(new ItemStack(Items.IRON_LEGGINGS), 7, 1, 12, 1, 0.2f), new h(new ItemStack(Items.IRON_BOOTS), 4, 1, 12, 1, 0.2f), new h(new ItemStack(Items.IRON_HELMET), 5, 1, 12, 1, 0.2f), new h(new ItemStack(Items.IRON_CHESTPLATE), 9, 1, 12, 1, 0.2f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.IRON_INGOT, 4, 12, 10), new h(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f), new h(new ItemStack(Items.CHAINMAIL_BOOTS), 1, 1, 12, 5, 0.2f), new h(new ItemStack(Items.CHAINMAIL_LEGGINGS), 3, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.LAVA_BUCKET, 1, 12, 20), new b(Items.DIAMOND, 1, 12, 20), new h(new ItemStack(Items.CHAINMAIL_HELMET), 1, 1, 12, 10, 0.2f), new h(new ItemStack(Items.CHAINMAIL_CHESTPLATE), 4, 1, 12, 10, 0.2f), new h(new ItemStack(Items.SHIELD), 5, 1, 12, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new e(Items.DIAMOND_LEGGINGS, 14, 3, 15, 0.2f), new e(Items.DIAMOND_BOOTS, 8, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.DIAMOND_HELMET, 8, 3, 30, 0.2f), new e(Items.DIAMOND_CHESTPLATE, 16, 3, 30, 0.2f)})));
        var0.put(VillagerProfession.WEAPONSMITH, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 16, 2), new h(new ItemStack(Items.IRON_AXE), 3, 1, 12, 1, 0.2f), new e(Items.IRON_SWORD, 2, 3, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.IRON_INGOT, 4, 12, 10), new h(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.FLINT, 24, 12, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.DIAMOND, 1, 12, 30), new e(Items.DIAMOND_AXE, 12, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.DIAMOND_SWORD, 8, 3, 30, 0.2f)})));
        var0.put(VillagerProfession.TOOLSMITH, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 16, 2), new h(new ItemStack(Items.STONE_AXE), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.STONE_SHOVEL), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.STONE_PICKAXE), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.STONE_HOE), 1, 1, 12, 1, 0.2f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.IRON_INGOT, 4, 12, 10), new h(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.FLINT, 30, 12, 20), new e(Items.IRON_AXE, 1, 3, 10, 0.2f), new e(Items.IRON_SHOVEL, 2, 3, 10, 0.2f), new e(Items.IRON_PICKAXE, 3, 3, 10, 0.2f), new h(new ItemStack(Items.DIAMOND_HOE), 4, 1, 3, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.DIAMOND, 1, 12, 30), new e(Items.DIAMOND_AXE, 12, 3, 15, 0.2f), new e(Items.DIAMOND_SHOVEL, 5, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.DIAMOND_PICKAXE, 13, 3, 30, 0.2f)})));
        var0.put(VillagerProfession.BUTCHER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.CHICKEN, 14, 16, 2), new b(Items.PORKCHOP, 7, 16, 2), new b(Items.RABBIT, 4, 16, 2), new h(Items.RABBIT_STEW, 1, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 16, 2), new h(Items.COOKED_PORKCHOP, 1, 5, 16, 5), new h(Items.COOKED_CHICKEN, 1, 8, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.MUTTON, 7, 16, 20), new b(Items.BEEF, 10, 16, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.DRIED_KELP_BLOCK, 10, 12, 30)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.SWEET_BERRIES, 10, 12, 30)})));
        var0.put(VillagerProfession.LEATHERWORKER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.LEATHER, 6, 16, 2), new a(Items.LEATHER_LEGGINGS, 3), new a(Items.LEATHER_CHESTPLATE, 7)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.FLINT, 26, 12, 10), new a(Items.LEATHER_HELMET, 5, 12, 5), new a(Items.LEATHER_BOOTS, 4, 12, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.RABBIT_HIDE, 9, 12, 20), new a(Items.LEATHER_CHESTPLATE, 7)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.SCUTE, 4, 12, 30), new a(Items.LEATHER_HORSE_ARMOR, 6, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(new ItemStack(Items.SADDLE), 6, 1, 12, 30, 0.2f), new a(Items.LEATHER_HELMET, 5, 12, 30)})));
        var0.put(VillagerProfession.MASON, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.CLAY_BALL, 10, 16, 2), new h(Items.BRICK, 1, 10, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Blocks.STONE, 20, 16, 10), new h(Blocks.CHISELED_STONE_BRICKS, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Blocks.GRANITE, 16, 16, 20), new b(Blocks.ANDESITE, 16, 16, 20), new b(Blocks.DIORITE, 16, 16, 20), new h(Blocks.DRIPSTONE_BLOCK, 1, 4, 16, 10), new h(Blocks.POLISHED_ANDESITE, 1, 4, 16, 10), new h(Blocks.POLISHED_DIORITE, 1, 4, 16, 10), new h(Blocks.POLISHED_GRANITE, 1, 4, 16, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.QUARTZ, 12, 12, 30), new h(Blocks.ORANGE_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.WHITE_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.BLUE_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.LIGHT_BLUE_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.GRAY_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.LIGHT_GRAY_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.BLACK_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.RED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.PINK_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.MAGENTA_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.LIME_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.GREEN_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.CYAN_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.PURPLE_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.YELLOW_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.BROWN_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.ORANGE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.WHITE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.BLUE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.GRAY_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.BLACK_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.RED_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.PINK_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.MAGENTA_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.LIME_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.GREEN_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.CYAN_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.PURPLE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.YELLOW_GLAZED_TERRACOTTA, 1, 1, 12, 15), new h(Blocks.BROWN_GLAZED_TERRACOTTA, 1, 1, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Blocks.QUARTZ_PILLAR, 1, 1, 12, 30), new h(Blocks.QUARTZ_BLOCK, 1, 1, 12, 30)})));
    });
    public static final Int2ObjectMap<IMerchantRecipeOption[]> WANDERING_TRADER_TRADES = VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new h(Items.SEA_PICKLE, 2, 1, 5, 1), new h(Items.SLIME_BALL, 4, 1, 5, 1), new h(Items.GLOWSTONE, 2, 1, 5, 1), new h(Items.NAUTILUS_SHELL, 5, 1, 5, 1), new h(Items.FERN, 1, 1, 12, 1), new h(Items.SUGAR_CANE, 1, 1, 8, 1), new h(Items.PUMPKIN, 1, 1, 4, 1), new h(Items.KELP, 3, 1, 12, 1), new h(Items.CACTUS, 3, 1, 8, 1), new h(Items.DANDELION, 1, 1, 12, 1), new h(Items.POPPY, 1, 1, 12, 1), new h(Items.BLUE_ORCHID, 1, 1, 8, 1), new h(Items.ALLIUM, 1, 1, 12, 1), new h(Items.AZURE_BLUET, 1, 1, 12, 1), new h(Items.RED_TULIP, 1, 1, 12, 1), new h(Items.ORANGE_TULIP, 1, 1, 12, 1), new h(Items.WHITE_TULIP, 1, 1, 12, 1), new h(Items.PINK_TULIP, 1, 1, 12, 1), new h(Items.OXEYE_DAISY, 1, 1, 12, 1), new h(Items.CORNFLOWER, 1, 1, 12, 1), new h(Items.LILY_OF_THE_VALLEY, 1, 1, 7, 1), new h(Items.WHEAT_SEEDS, 1, 1, 12, 1), new h(Items.BEETROOT_SEEDS, 1, 1, 12, 1), new h(Items.PUMPKIN_SEEDS, 1, 1, 12, 1), new h(Items.MELON_SEEDS, 1, 1, 12, 1), new h(Items.ACACIA_SAPLING, 5, 1, 8, 1), new h(Items.BIRCH_SAPLING, 5, 1, 8, 1), new h(Items.DARK_OAK_SAPLING, 5, 1, 8, 1), new h(Items.JUNGLE_SAPLING, 5, 1, 8, 1), new h(Items.OAK_SAPLING, 5, 1, 8, 1), new h(Items.SPRUCE_SAPLING, 5, 1, 8, 1), new h(Items.MANGROVE_PROPAGULE, 5, 1, 8, 1), new h(Items.RED_DYE, 1, 3, 12, 1), new h(Items.WHITE_DYE, 1, 3, 12, 1), new h(Items.BLUE_DYE, 1, 3, 12, 1), new h(Items.PINK_DYE, 1, 3, 12, 1), new h(Items.BLACK_DYE, 1, 3, 12, 1), new h(Items.GREEN_DYE, 1, 3, 12, 1), new h(Items.LIGHT_GRAY_DYE, 1, 3, 12, 1), new h(Items.MAGENTA_DYE, 1, 3, 12, 1), new h(Items.YELLOW_DYE, 1, 3, 12, 1), new h(Items.GRAY_DYE, 1, 3, 12, 1), new h(Items.PURPLE_DYE, 1, 3, 12, 1), new h(Items.LIGHT_BLUE_DYE, 1, 3, 12, 1), new h(Items.LIME_DYE, 1, 3, 12, 1), new h(Items.ORANGE_DYE, 1, 3, 12, 1), new h(Items.BROWN_DYE, 1, 3, 12, 1), new h(Items.CYAN_DYE, 1, 3, 12, 1), new h(Items.BRAIN_CORAL_BLOCK, 3, 1, 8, 1), new h(Items.BUBBLE_CORAL_BLOCK, 3, 1, 8, 1), new h(Items.FIRE_CORAL_BLOCK, 3, 1, 8, 1), new h(Items.HORN_CORAL_BLOCK, 3, 1, 8, 1), new h(Items.TUBE_CORAL_BLOCK, 3, 1, 8, 1), new h(Items.VINE, 1, 1, 12, 1), new h(Items.BROWN_MUSHROOM, 1, 1, 12, 1), new h(Items.RED_MUSHROOM, 1, 1, 12, 1), new h(Items.LILY_PAD, 1, 2, 5, 1), new h(Items.SMALL_DRIPLEAF, 1, 2, 5, 1), new h(Items.SAND, 1, 8, 8, 1), new h(Items.RED_SAND, 1, 4, 6, 1), new h(Items.POINTED_DRIPSTONE, 1, 2, 5, 1), new h(Items.ROOTED_DIRT, 1, 2, 5, 1), new h(Items.MOSS_BLOCK, 1, 2, 5, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new h(Items.TROPICAL_FISH_BUCKET, 5, 1, 4, 1), new h(Items.PUFFERFISH_BUCKET, 5, 1, 4, 1), new h(Items.PACKED_ICE, 3, 1, 6, 1), new h(Items.BLUE_ICE, 6, 1, 6, 1), new h(Items.GUNPOWDER, 1, 1, 8, 1), new h(Items.PODZOL, 3, 3, 6, 1)}));

    private static Int2ObjectMap<IMerchantRecipeOption[]> toIntMap(ImmutableMap<Integer, IMerchantRecipeOption[]> var0) {
        return new Int2ObjectOpenHashMap(var0);
    }

    public static interface IMerchantRecipeOption {
        @Nullable
        public MerchantRecipe getOffer(Entity var1, RandomSource var2);
    }

    static class b
    implements IMerchantRecipeOption {
        private final Item item;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public b(IMaterial var0, int var1, int var2, int var3) {
            this.item = var0.asItem();
            this.cost = var1;
            this.maxUses = var2;
            this.villagerXp = var3;
            this.priceMultiplier = 0.05f;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            ItemStack var2 = new ItemStack(this.item, this.cost);
            return new MerchantRecipe(var2, new ItemStack(Items.EMERALD), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class h
    implements IMerchantRecipeOption {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public h(Block var0, int var1, int var2, int var3, int var4) {
            this(new ItemStack(var0), var1, var2, var3, var4);
        }

        public h(Item var0, int var1, int var2, int var3) {
            this(new ItemStack(var0), var1, var2, 12, var3);
        }

        public h(Item var0, int var1, int var2, int var3, int var4) {
            this(new ItemStack(var0), var1, var2, var3, var4);
        }

        public h(ItemStack var0, int var1, int var2, int var3, int var4) {
            this(var0, var1, var2, var3, var4, 0.05f);
        }

        public h(ItemStack var0, int var1, int var2, int var3, int var4, float var5) {
            this.itemStack = var0;
            this.emeraldCost = var1;
            this.numberOfItems = var2;
            this.maxUses = var3;
            this.villagerXp = var4;
            this.priceMultiplier = var5;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            return new MerchantRecipe(new ItemStack(Items.EMERALD, this.emeraldCost), new ItemStack(this.itemStack.getItem(), this.numberOfItems), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class i
    implements IMerchantRecipeOption {
        final MobEffectList effect;
        final int duration;
        final int xp;
        private final float priceMultiplier;

        public i(MobEffectList var0, int var1, int var2) {
            this.effect = var0;
            this.duration = var1;
            this.xp = var2;
            this.priceMultiplier = 0.05f;
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            ItemStack var2 = new ItemStack(Items.SUSPICIOUS_STEW, 1);
            ItemSuspiciousStew.saveMobEffect(var2, this.effect, this.duration);
            return new MerchantRecipe(new ItemStack(Items.EMERALD, 1), var2, 12, this.xp, this.priceMultiplier);
        }
    }

    static class g
    implements IMerchantRecipeOption {
        private final ItemStack fromItem;
        private final int fromCount;
        private final int emeraldCost;
        private final ItemStack toItem;
        private final int toCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public g(IMaterial var0, int var1, Item var2, int var3, int var4, int var5) {
            this(var0, var1, 1, var2, var3, var4, var5);
        }

        public g(IMaterial var0, int var1, int var2, Item var3, int var4, int var5, int var6) {
            this.fromItem = new ItemStack(var0);
            this.fromCount = var1;
            this.emeraldCost = var2;
            this.toItem = new ItemStack(var3);
            this.toCount = var4;
            this.maxUses = var5;
            this.villagerXp = var6;
            this.priceMultiplier = 0.05f;
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            return new MerchantRecipe(new ItemStack(Items.EMERALD, this.emeraldCost), new ItemStack(this.fromItem.getItem(), this.fromCount), new ItemStack(this.toItem.getItem(), this.toCount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class e
    implements IMerchantRecipeOption {
        private final ItemStack itemStack;
        private final int baseEmeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public e(Item var0, int var1, int var2, int var3) {
            this(var0, var1, var2, var3, 0.05f);
        }

        public e(Item var0, int var1, int var2, int var3, float var4) {
            this.itemStack = new ItemStack(var0);
            this.baseEmeraldCost = var1;
            this.maxUses = var2;
            this.villagerXp = var3;
            this.priceMultiplier = var4;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            int var2 = 5 + var1.nextInt(15);
            ItemStack var3 = EnchantmentManager.enchantItem(var1, new ItemStack(this.itemStack.getItem()), var2, false);
            int var4 = Math.min(this.baseEmeraldCost + var2, 64);
            ItemStack var5 = new ItemStack(Items.EMERALD, var4);
            return new MerchantRecipe(var5, var3, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class c
    implements IMerchantRecipeOption {
        private final Map<VillagerType, Item> trades;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;

        public c(int var02, int var12, int var2, Map<VillagerType, Item> var3) {
            IRegistry.VILLAGER_TYPE.stream().filter(var1 -> !var3.containsKey(var1)).findAny().ifPresent(var0 -> {
                throw new IllegalStateException("Missing trade for villager type: " + IRegistry.VILLAGER_TYPE.getKey((VillagerType)var0));
            });
            this.trades = var3;
            this.cost = var02;
            this.maxUses = var12;
            this.villagerXp = var2;
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            if (var0 instanceof VillagerDataHolder) {
                ItemStack var2 = new ItemStack(this.trades.get(((VillagerDataHolder)((Object)var0)).getVillagerData().getType()), this.cost);
                return new MerchantRecipe(var2, new ItemStack(Items.EMERALD), this.maxUses, this.villagerXp, 0.05f);
            }
            return null;
        }
    }

    static class j
    implements IMerchantRecipeOption {
        private final ItemStack toItem;
        private final int toCount;
        private final int emeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final Item fromItem;
        private final int fromCount;
        private final float priceMultiplier;

        public j(Item var0, int var1, Item var2, int var3, int var4, int var5, int var6) {
            this.toItem = new ItemStack(var2);
            this.emeraldCost = var4;
            this.maxUses = var5;
            this.villagerXp = var6;
            this.fromItem = var0;
            this.fromCount = var1;
            this.toCount = var3;
            this.priceMultiplier = 0.05f;
        }

        @Override
        public MerchantRecipe getOffer(Entity var02, RandomSource var1) {
            ItemStack var2 = new ItemStack(Items.EMERALD, this.emeraldCost);
            List var3 = IRegistry.POTION.stream().filter(var0 -> !var0.getEffects().isEmpty() && PotionBrewer.isBrewablePotion(var0)).collect(Collectors.toList());
            PotionRegistry var4 = (PotionRegistry)var3.get(var1.nextInt(var3.size()));
            ItemStack var5 = PotionUtil.setPotion(new ItemStack(this.toItem.getItem(), this.toCount), var4);
            return new MerchantRecipe(var2, new ItemStack(this.fromItem, this.fromCount), var5, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class d
    implements IMerchantRecipeOption {
        private final int villagerXp;

        public d(int var0) {
            this.villagerXp = var0;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            List var2 = IRegistry.ENCHANTMENT.stream().filter(Enchantment::isTradeable).collect(Collectors.toList());
            Enchantment var3 = (Enchantment)var2.get(var1.nextInt(var2.size()));
            int var4 = MathHelper.nextInt(var1, var3.getMinLevel(), var3.getMaxLevel());
            ItemStack var5 = ItemEnchantedBook.createForEnchantment(new WeightedRandomEnchant(var3, var4));
            int var6 = 2 + var1.nextInt(5 + var4 * 10) + 3 * var4;
            if (var3.isTreasureOnly()) {
                var6 *= 2;
            }
            if (var6 > 64) {
                var6 = 64;
            }
            return new MerchantRecipe(new ItemStack(Items.EMERALD, var6), new ItemStack(Items.BOOK), var5, 12, this.villagerXp, 0.2f);
        }
    }

    static class k
    implements IMerchantRecipeOption {
        private final int emeraldCost;
        private final TagKey<Structure> destination;
        private final String displayName;
        private final MapIcon.Type destinationType;
        private final int maxUses;
        private final int villagerXp;

        public k(int var0, TagKey<Structure> var1, String var2, MapIcon.Type var3, int var4, int var5) {
            this.emeraldCost = var0;
            this.destination = var1;
            this.displayName = var2;
            this.destinationType = var3;
            this.maxUses = var4;
            this.villagerXp = var5;
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            if (!(var0.level instanceof WorldServer)) {
                return null;
            }
            WorldServer var2 = (WorldServer)var0.level;
            BlockPosition var3 = var2.findNearestMapStructure(this.destination, var0.blockPosition(), 100, true);
            if (var3 != null) {
                ItemStack var4 = ItemWorldMap.create(var2, var3.getX(), var3.getZ(), (byte)2, true, true);
                ItemWorldMap.renderBiomePreviewMap(var2, var4);
                WorldMap.addTargetDecoration(var4, var3, "+", this.destinationType);
                var4.setHoverName(IChatBaseComponent.translatable(this.displayName));
                return new MerchantRecipe(new ItemStack(Items.EMERALD, this.emeraldCost), new ItemStack(Items.COMPASS), var4, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }

    static class a
    implements IMerchantRecipeOption {
        private final Item item;
        private final int value;
        private final int maxUses;
        private final int villagerXp;

        public a(Item var0, int var1) {
            this(var0, var1, 12, 1);
        }

        public a(Item var0, int var1, int var2, int var3) {
            this.item = var0;
            this.value = var1;
            this.maxUses = var2;
            this.villagerXp = var3;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            ItemStack var2 = new ItemStack(Items.EMERALD, this.value);
            ItemStack var3 = new ItemStack(this.item);
            if (this.item instanceof ItemArmorColorable) {
                ArrayList var4 = Lists.newArrayList();
                var4.add(a.getRandomDye(var1));
                if (var1.nextFloat() > 0.7f) {
                    var4.add(a.getRandomDye(var1));
                }
                if (var1.nextFloat() > 0.8f) {
                    var4.add(a.getRandomDye(var1));
                }
                var3 = IDyeable.dyeArmor(var3, var4);
            }
            return new MerchantRecipe(var2, var3, this.maxUses, this.villagerXp, 0.2f);
        }

        private static ItemDye getRandomDye(RandomSource var0) {
            return ItemDye.byColor(EnumColor.byId(var0.nextInt(16)));
        }
    }
}

