/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinAI;

public class BehaviorStartAdmiringItem<E extends EntityPiglin>
extends Behavior<E> {
    private final int admireDuration;

    public BehaviorStartAdmiringItem(int var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ADMIRING_ITEM, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.ADMIRING_DISABLED, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.admireDuration = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        EntityItem var2 = ((EntityPiglin)var1).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM).get();
        return PiglinAI.isLovedItem(var2.getItem());
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        ((EntityPiglin)var1).getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, true, this.admireDuration);
    }
}

