/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private IBlockData blockState = Blocks.SAND.defaultBlockState();
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    public boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    @Nullable
    public NBTTagCompound blockData;
    protected static final DataWatcherObject<BlockPosition> DATA_START_POS = DataWatcher.defineId(EntityFallingBlock.class, DataWatcherRegistry.BLOCK_POS);

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> var0, World var1) {
        super(var0, var1);
    }

    private EntityFallingBlock(World var0, double var1, double var3, double var5, IBlockData var7) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.FALLING_BLOCK, var0);
        this.blockState = var7;
        this.blocksBuilding = true;
        this.setPos(var1, var3, var5);
        this.setDeltaMovement(Vec3D.ZERO);
        this.xo = var1;
        this.yo = var3;
        this.zo = var5;
        this.setStartPos(this.blockPosition());
    }

    public static EntityFallingBlock fall(World var0, BlockPosition var1, IBlockData var2) {
        EntityFallingBlock var3 = new EntityFallingBlock(var0, (double)var1.getX() + 0.5, var1.getY(), (double)var1.getZ() + 0.5, var2.hasProperty(BlockProperties.WATERLOGGED) ? (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, false) : var2);
        var0.setBlock(var1, var2.getFluidState().createLegacyBlock(), 3);
        var0.addFreshEntity(var3);
        return var3;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    public void setStartPos(BlockPosition var0) {
        this.entityData.set(DATA_START_POS, var0);
    }

    public BlockPosition getStartPos() {
        return this.entityData.get(DATA_START_POS);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_START_POS, BlockPosition.ZERO);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    public void tick() {
        if (this.blockState.isAir()) {
            this.discard();
            return;
        }
        Block var0 = this.blockState.getBlock();
        ++this.time;
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        if (!this.level.isClientSide) {
            Object var6;
            BlockPosition var1 = this.blockPosition();
            boolean var2 = this.blockState.getBlock() instanceof BlockConcretePowder;
            boolean var3 = var2 && this.level.getFluidState(var1).is(TagsFluid.WATER);
            double var4 = this.getDeltaMovement().lengthSqr();
            if (var2 && var4 > 1.0 && ((MovingObjectPositionBlock)(var6 = this.level.clip(new RayTrace(new Vec3D(this.xo, this.yo, this.zo), this.position(), RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.SOURCE_ONLY, this)))).getType() != MovingObjectPosition.EnumMovingObjectType.MISS && this.level.getFluidState(((MovingObjectPositionBlock)var6).getBlockPos()).is(TagsFluid.WATER)) {
                var1 = ((MovingObjectPositionBlock)var6).getBlockPos();
                var3 = true;
            }
            if (this.onGround || var3) {
                var6 = this.level.getBlockState(var1);
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                if (!((BlockBase.BlockData)var6).is(Blocks.MOVING_PISTON)) {
                    if (!this.cancelDrop) {
                        boolean var9;
                        boolean var7 = ((BlockBase.BlockData)var6).canBeReplaced(new BlockActionContextDirectional(this.level, var1, EnumDirection.DOWN, ItemStack.EMPTY, EnumDirection.UP));
                        boolean var8 = BlockFalling.isFree(this.level.getBlockState(var1.below())) && (!var2 || !var3);
                        boolean bl = var9 = this.blockState.canSurvive(this.level, var1) && !var8;
                        if (var7 && var9) {
                            if (this.blockState.hasProperty(BlockProperties.WATERLOGGED) && this.level.getFluidState(var1).getType() == FluidTypes.WATER) {
                                this.blockState = (IBlockData)this.blockState.setValue(BlockProperties.WATERLOGGED, true);
                            }
                            if (this.level.setBlock(var1, this.blockState, 3)) {
                                TileEntity var10;
                                ((WorldServer)this.level).getChunkSource().chunkMap.broadcast(this, new PacketPlayOutBlockChange(var1, this.level.getBlockState(var1)));
                                this.discard();
                                if (var0 instanceof Fallable) {
                                    ((Fallable)((Object)var0)).onLand(this.level, var1, this.blockState, (IBlockData)var6, this);
                                }
                                if (this.blockData != null && this.blockState.hasBlockEntity() && (var10 = this.level.getBlockEntity(var1)) != null) {
                                    NBTTagCompound var11 = var10.saveWithoutMetadata();
                                    for (String var13 : this.blockData.getAllKeys()) {
                                        var11.put(var13, this.blockData.get(var13).copy());
                                    }
                                    try {
                                        var10.load(var11);
                                    }
                                    catch (Exception var12) {
                                        LOGGER.error("Failed to load block entity from falling block", (Throwable)var12);
                                    }
                                    var10.setChanged();
                                }
                            } else if (this.dropItem && this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                this.discard();
                                this.callOnBrokenAfterFall(var0, var1);
                                this.spawnAtLocation(var0);
                            }
                        } else {
                            this.discard();
                            if (this.dropItem && this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                this.callOnBrokenAfterFall(var0, var1);
                                this.spawnAtLocation(var0);
                            }
                        }
                    } else {
                        this.discard();
                        this.callOnBrokenAfterFall(var0, var1);
                    }
                }
            } else if (!(this.level.isClientSide || (this.time <= 100 || var1.getY() > this.level.getMinBuildHeight() && var1.getY() <= this.level.getMaxBuildHeight()) && this.time <= 600)) {
                if (this.dropItem && this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.spawnAtLocation(var0);
                }
                this.discard();
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
    }

    public void callOnBrokenAfterFall(Block var0, BlockPosition var1) {
        if (var0 instanceof Fallable) {
            ((Fallable)((Object)var0)).onBrokenAfterFall(this.level, var1, this);
        }
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var22) {
        DamageSource var5;
        Predicate<Entity> var4;
        if (!this.hurtEntities) {
            return false;
        }
        int var3 = MathHelper.ceil(var0 - 1.0f);
        if (var3 < 0) {
            return false;
        }
        if (this.blockState.getBlock() instanceof Fallable) {
            Fallable var6 = (Fallable)((Object)this.blockState.getBlock());
            var4 = var6.getHurtsEntitySelector();
            var5 = var6.getFallDamageSource();
        } else {
            var4 = IEntitySelector.NO_SPECTATORS;
            var5 = DamageSource.FALLING_BLOCK;
        }
        float var6 = Math.min(MathHelper.floor((float)var3 * this.fallDamagePerDistance), this.fallDamageMax);
        this.level.getEntities(this, this.getBoundingBox(), var4).forEach(var2 -> var2.hurt(var5, var6));
        boolean var7 = this.blockState.is(TagsBlock.ANVIL);
        if (var7 && var6 > 0.0f && this.random.nextFloat() < 0.05f + (float)var3 * 0.05f) {
            IBlockData var8 = BlockAnvil.damage(this.blockState);
            if (var8 == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = var8;
            }
        }
        return false;
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.put("BlockState", GameProfileSerializer.writeBlockState(this.blockState));
        var0.putInt("Time", this.time);
        var0.putBoolean("DropItem", this.dropItem);
        var0.putBoolean("HurtEntities", this.hurtEntities);
        var0.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        var0.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            var0.put("TileEntityData", this.blockData);
        }
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        this.blockState = GameProfileSerializer.readBlockState(var0.getCompound("BlockState"));
        this.time = var0.getInt("Time");
        if (var0.contains("HurtEntities", 99)) {
            this.hurtEntities = var0.getBoolean("HurtEntities");
            this.fallDamagePerDistance = var0.getFloat("FallHurtAmount");
            this.fallDamageMax = var0.getInt("FallHurtMax");
        } else if (this.blockState.is(TagsBlock.ANVIL)) {
            this.hurtEntities = true;
        }
        if (var0.contains("DropItem", 99)) {
            this.dropItem = var0.getBoolean("DropItem");
        }
        if (var0.contains("TileEntityData", 10)) {
            this.blockData = var0.getCompound("TileEntityData");
        }
        if (this.blockState.isAir()) {
            this.blockState = Blocks.SAND.defaultBlockState();
        }
    }

    public void setHurtsEntities(float var0, int var1) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = var0;
        this.fallDamageMax = var1;
    }

    @Override
    public boolean displayFireAnimation() {
        return false;
    }

    @Override
    public void fillCrashReportCategory(CrashReportSystemDetails var0) {
        super.fillCrashReportCategory(var0);
        var0.setDetail("Immitating BlockState", this.blockState.toString());
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    @Override
    public Packet<?> getAddEntityPacket() {
        return new PacketPlayOutSpawnEntity(this, Block.getId(this.getBlockState()));
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        this.blockState = Block.stateById(var0.getData());
        this.blocksBuilding = true;
        double var1 = var0.getX();
        double var3 = var0.getY();
        double var5 = var0.getZ();
        this.setPos(var1, var3, var5);
        this.setStartPos(this.blockPosition());
    }
}

