/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public abstract class EntityHanging
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final Predicate<Entity> HANGING_ENTITY = var0 -> var0 instanceof EntityHanging;
    private int checkInterval;
    public BlockPosition pos;
    protected EnumDirection direction = EnumDirection.SOUTH;

    protected EntityHanging(EntityTypes<? extends EntityHanging> var0, World var1) {
        super(var0, var1);
    }

    protected EntityHanging(EntityTypes<? extends EntityHanging> var0, World var1, BlockPosition var2) {
        this(var0, var1);
        this.pos = var2;
    }

    @Override
    protected void defineSynchedData() {
    }

    public void setDirection(EnumDirection var0) {
        Validate.notNull((Object)var0);
        Validate.isTrue((boolean)var0.getAxis().isHorizontal());
        this.direction = var0;
        this.setYRot(this.direction.get2DDataValue() * 90);
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    protected void recalculateBoundingBox() {
        if (this.direction == null) {
            return;
        }
        double var0 = (double)this.pos.getX() + 0.5;
        double var2 = (double)this.pos.getY() + 0.5;
        double var4 = (double)this.pos.getZ() + 0.5;
        double var6 = 0.46875;
        double var8 = this.offs(this.getWidth());
        double var10 = this.offs(this.getHeight());
        var0 -= (double)this.direction.getStepX() * 0.46875;
        var4 -= (double)this.direction.getStepZ() * 0.46875;
        EnumDirection var12 = this.direction.getCounterClockWise();
        this.setPosRaw(var0 += var8 * (double)var12.getStepX(), var2 += var10, var4 += var8 * (double)var12.getStepZ());
        double var13 = this.getWidth();
        double var15 = this.getHeight();
        double var17 = this.getWidth();
        if (this.direction.getAxis() == EnumDirection.EnumAxis.Z) {
            var17 = 1.0;
        } else {
            var13 = 1.0;
        }
        this.setBoundingBox(new AxisAlignedBB(var0 - (var13 /= 32.0), var2 - (var15 /= 32.0), var4 - (var17 /= 32.0), var0 + var13, var2 + var15, var4 + var17));
    }

    private double offs(int var0) {
        return var0 % 32 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            this.checkOutOfWorld();
            if (this.checkInterval++ == 100) {
                this.checkInterval = 0;
                if (!this.isRemoved() && !this.survives()) {
                    this.discard();
                    this.dropItem(null);
                }
            }
        }
    }

    public boolean survives() {
        if (!this.level.noCollision(this)) {
            return false;
        }
        int var0 = Math.max(1, this.getWidth() / 16);
        int var1 = Math.max(1, this.getHeight() / 16);
        BlockPosition var2 = this.pos.relative(this.direction.getOpposite());
        EnumDirection var3 = this.direction.getCounterClockWise();
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (int var5 = 0; var5 < var0; ++var5) {
            for (int var6 = 0; var6 < var1; ++var6) {
                int var7 = (var0 - 1) / -2;
                int var8 = (var1 - 1) / -2;
                var4.set(var2).move(var3, var5 + var7).move(EnumDirection.UP, var6 + var8);
                IBlockData var9 = this.level.getBlockState(var4);
                if (var9.getMaterial().isSolid() || BlockDiodeAbstract.isDiode(var9)) continue;
                return false;
            }
        }
        return this.level.getEntities(this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity var0) {
        if (var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            if (!this.level.mayInteract(var1, this.pos)) {
                return true;
            }
            return this.hurt(DamageSource.playerAttack(var1), 0.0f);
        }
        return false;
    }

    @Override
    public EnumDirection getDirection() {
        return this.direction;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        if (!this.isRemoved() && !this.level.isClientSide) {
            this.kill();
            this.markHurt();
            this.dropItem(var0.getEntity());
        }
        return true;
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        if (!this.level.isClientSide && !this.isRemoved() && var1.lengthSqr() > 0.0) {
            this.kill();
            this.dropItem(null);
        }
    }

    @Override
    public void push(double var0, double var2, double var4) {
        if (!this.level.isClientSide && !this.isRemoved() && var0 * var0 + var2 * var2 + var4 * var4 > 0.0) {
            this.kill();
            this.dropItem(null);
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        BlockPosition var1 = this.getPos();
        var0.putInt("TileX", var1.getX());
        var0.putInt("TileY", var1.getY());
        var0.putInt("TileZ", var1.getZ());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        BlockPosition var1 = new BlockPosition(var0.getInt("TileX"), var0.getInt("TileY"), var0.getInt("TileZ"));
        if (!var1.closerThan(this.blockPosition(), 16.0)) {
            LOGGER.error("Hanging entity at invalid position: {}", (Object)var1);
            return;
        }
        this.pos = var1;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract void dropItem(@Nullable Entity var1);

    public abstract void playPlacementSound();

    @Override
    public EntityItem spawnAtLocation(ItemStack var0, float var1) {
        EntityItem var2 = new EntityItem(this.level, this.getX() + (double)((float)this.direction.getStepX() * 0.15f), this.getY() + (double)var1, this.getZ() + (double)((float)this.direction.getStepZ() * 0.15f), var0);
        var2.setDefaultPickUpDelay();
        this.level.addFreshEntity(var2);
        return var2;
    }

    @Override
    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    @Override
    public void setPos(double var0, double var2, double var4) {
        this.pos = new BlockPosition(var0, var2, var4);
        this.recalculateBoundingBox();
        this.hasImpulse = true;
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    @Override
    public float rotate(EnumBlockRotation var0) {
        if (this.direction.getAxis() != EnumDirection.EnumAxis.Y) {
            switch (var0) {
                case CLOCKWISE_180: {
                    this.direction = this.direction.getOpposite();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.direction = this.direction.getCounterClockWise();
                    break;
                }
                case CLOCKWISE_90: {
                    this.direction = this.direction.getClockWise();
                    break;
                }
            }
        }
        float var1 = MathHelper.wrapDegrees(this.getYRot());
        switch (var0) {
            case CLOCKWISE_180: {
                return var1 + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return var1 + 90.0f;
            }
            case CLOCKWISE_90: {
                return var1 + 270.0f;
            }
        }
        return var1;
    }

    @Override
    public float mirror(EnumBlockMirror var0) {
        return this.rotate(var0.getRotation(this.direction));
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
    }

    @Override
    public void refreshDimensions() {
    }
}

