/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonController;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;

public class DragonControllerHold
extends AbstractDragonController {
    private static final PathfinderTargetCondition NEW_TARGET_TARGETING = PathfinderTargetCondition.forCombat().ignoreLineOfSight();
    @Nullable
    private PathEntity currentPath;
    @Nullable
    private Vec3D targetLocation;
    private boolean clockwise;

    public DragonControllerHold(EntityEnderDragon var0) {
        super(var0);
    }

    public DragonControllerPhase<DragonControllerHold> getPhase() {
        return DragonControllerPhase.HOLDING_PATTERN;
    }

    @Override
    public void doServerTick() {
        double var0;
        double d2 = var0 = this.targetLocation == null ? 0.0 : this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (var0 < 100.0 || var0 > 22500.0 || this.dragon.horizontalCollision || this.dragon.verticalCollision) {
            this.findNewTarget();
        }
    }

    @Override
    public void begin() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    @Nullable
    public Vec3D getFlyTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget() {
        int var1;
        if (this.currentPath != null && this.currentPath.isDone()) {
            BlockPosition var0 = this.dragon.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPosition(WorldGenEndTrophy.END_PODIUM_LOCATION));
            int n2 = var1 = this.dragon.getDragonFight() == null ? 0 : this.dragon.getDragonFight().getCrystalsAlive();
            if (this.dragon.getRandom().nextInt(var1 + 3) == 0) {
                this.dragon.getPhaseManager().setPhase(DragonControllerPhase.LANDING_APPROACH);
                return;
            }
            double var2 = 64.0;
            EntityHuman var4 = this.dragon.level.getNearestPlayer(NEW_TARGET_TARGETING, this.dragon, (double)var0.getX(), (double)var0.getY(), var0.getZ());
            if (var4 != null) {
                var2 = var0.distToCenterSqr(var4.position()) / 512.0;
            }
            if (var4 != null && (this.dragon.getRandom().nextInt(MathHelper.abs((int)var2) + 2) == 0 || this.dragon.getRandom().nextInt(var1 + 2) == 0)) {
                this.strafePlayer(var4);
                return;
            }
        }
        if (this.currentPath == null || this.currentPath.isDone()) {
            int var0;
            var1 = var0 = this.dragon.findClosestNode();
            if (this.dragon.getRandom().nextInt(8) == 0) {
                this.clockwise = !this.clockwise;
                var1 += 6;
            }
            var1 = this.clockwise ? ++var1 : --var1;
            if (this.dragon.getDragonFight() == null || this.dragon.getDragonFight().getCrystalsAlive() < 0) {
                var1 -= 12;
                var1 &= 7;
                var1 += 12;
            } else if ((var1 %= 12) < 0) {
                var1 += 12;
            }
            this.currentPath = this.dragon.findPath(var0, var1, null);
            if (this.currentPath != null) {
                this.currentPath.advance();
            }
        }
        this.navigateToNextPathNode();
    }

    private void strafePlayer(EntityHuman var0) {
        this.dragon.getPhaseManager().setPhase(DragonControllerPhase.STRAFE_PLAYER);
        this.dragon.getPhaseManager().getPhase(DragonControllerPhase.STRAFE_PLAYER).setTarget(var0);
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isDone()) {
            double var5;
            BlockPosition var0 = this.currentPath.getNextNodePos();
            this.currentPath.advance();
            double var1 = var0.getX();
            double var3 = var0.getZ();
            while ((var5 = (double)((float)var0.getY() + this.dragon.getRandom().nextFloat() * 20.0f)) < (double)var0.getY()) {
            }
            this.targetLocation = new Vec3D(var1, var5, var3);
        }
    }

    @Override
    public void onCrystalDestroyed(EntityEnderCrystal var0, BlockPosition var1, DamageSource var2, @Nullable EntityHuman var3) {
        if (var3 != null && this.dragon.canAttack(var3)) {
            this.strafePlayer(var3);
        }
    }
}

