/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;

public class ShootTongue
extends Behavior<Frog> {
    public static final int TIME_OUT_DURATION = 100;
    public static final int CATCH_ANIMATION_DURATION = 6;
    public static final int TONGUE_ANIMATION_DURATION = 10;
    private static final float EATING_DISTANCE = 1.75f;
    private static final float EATING_MOVEMENT_FACTOR = 0.75f;
    public static final int UNREACHABLE_TONGUE_TARGETS_COOLDOWN_DURATION = 100;
    public static final int MAX_UNREACHBLE_TONGUE_TARGETS_IN_MEMORY = 5;
    private int eatAnimationTimer;
    private int calculatePathCounter;
    private final SoundEffect tongueSound;
    private final SoundEffect eatSound;
    private Vec3D itemSpawnPos;
    private a state = a.DONE;

    public ShootTongue(SoundEffect var0, SoundEffect var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 100);
        this.tongueSound = var0;
        this.eatSound = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, Frog var1) {
        EntityLiving var2 = var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        boolean var3 = this.canPathfindToTarget(var1, var2);
        if (!var3) {
            var1.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            this.addUnreachableTargetToMemory(var1, var2);
        }
        return var3 && var1.getPose() != EntityPose.CROAKING && Frog.canEat(var2);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, Frog var1, long var2) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.state != a.DONE && !var1.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void start(WorldServer var0, Frog var1, long var2) {
        EntityLiving var4 = var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        BehaviorUtil.lookAtEntity(var1, var4);
        var1.setTongueTarget(var4);
        var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var4.position(), 2.0f, 0));
        this.calculatePathCounter = 10;
        this.state = a.MOVE_TO_TARGET;
    }

    @Override
    protected void stop(WorldServer var0, Frog var1, long var2) {
        var1.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        var1.eraseTongueTarget();
        var1.setPose(EntityPose.STANDING);
    }

    private void eatEntity(WorldServer var0, Frog var1) {
        Entity var3;
        var0.playSound(null, var1, this.eatSound, SoundCategory.NEUTRAL, 2.0f, 1.0f);
        Optional<Entity> var2 = var1.getTongueTarget();
        if (var2.isPresent() && (var3 = var2.get()).isAlive()) {
            var1.doHurtTarget(var3);
            if (!var3.isAlive()) {
                var3.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    protected void tick(WorldServer var0, Frog var1, long var2) {
        EntityLiving var4 = var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        var1.setTongueTarget(var4);
        switch (this.state) {
            case MOVE_TO_TARGET: {
                if (var4.distanceTo(var1) < 1.75f) {
                    var0.playSound(null, var1, this.tongueSound, SoundCategory.NEUTRAL, 2.0f, 1.0f);
                    var1.setPose(EntityPose.USING_TONGUE);
                    var4.setDeltaMovement(var4.position().vectorTo(var1.position()).normalize().scale(0.75));
                    this.itemSpawnPos = var4.position();
                    this.eatAnimationTimer = 0;
                    this.state = a.CATCH_ANIMATION;
                    break;
                }
                if (this.calculatePathCounter <= 0) {
                    var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var4.position(), 2.0f, 0));
                    this.calculatePathCounter = 10;
                    break;
                }
                --this.calculatePathCounter;
                break;
            }
            case CATCH_ANIMATION: {
                if (this.eatAnimationTimer++ < 6) break;
                this.state = a.EAT_ANIMATION;
                this.eatEntity(var0, var1);
                break;
            }
            case EAT_ANIMATION: {
                if (this.eatAnimationTimer >= 10) {
                    this.state = a.DONE;
                    break;
                }
                ++this.eatAnimationTimer;
                break;
            }
        }
    }

    private boolean canPathfindToTarget(Frog var0, EntityLiving var1) {
        PathEntity var2 = var0.getNavigation().createPath(var1, 0);
        return var2 != null && var2.getDistToTarget() < 1.75f;
    }

    private void addUnreachableTargetToMemory(Frog var0, EntityLiving var1) {
        boolean var3;
        List var2 = var0.getBrain().getMemory(MemoryModuleType.UNREACHABLE_TONGUE_TARGETS).orElseGet(ArrayList::new);
        boolean bl = var3 = !var2.contains(var1.getUUID());
        if (var2.size() == 5 && var3) {
            var2.remove(0);
        }
        if (var3) {
            var2.add(var1.getUUID());
        }
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.UNREACHABLE_TONGUE_TARGETS, var2, 100L);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (Frog)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (Frog)entityLiving, l2);
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a MOVE_TO_TARGET = new a();
        public static final /* enum */ a CATCH_ANIMATION = new a();
        public static final /* enum */ a EAT_ANIMATION = new a();
        public static final /* enum */ a DONE = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{MOVE_TO_TARGET, CATCH_ANIMATION, EAT_ANIMATION, DONE};
        }

        static {
            e = a.a();
        }
    }
}

