/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityRabbit
extends EntityAnimal {
    public static final double STROLL_SPEED_MOD = 0.6;
    public static final double BREED_SPEED_MOD = 0.8;
    public static final double FOLLOW_SPEED_MOD = 1.0;
    public static final double FLEE_SPEED_MOD = 2.2;
    public static final double ATTACK_SPEED_MOD = 1.4;
    private static final DataWatcherObject<Integer> DATA_TYPE_ID = DataWatcher.defineId(EntityRabbit.class, DataWatcherRegistry.INT);
    public static final int TYPE_BROWN = 0;
    public static final int TYPE_WHITE = 1;
    public static final int TYPE_BLACK = 2;
    public static final int TYPE_WHITE_SPLOTCHED = 3;
    public static final int TYPE_GOLD = 4;
    public static final int TYPE_SALT = 5;
    public static final int TYPE_EVIL = 99;
    private static final MinecraftKey KILLER_BUNNY = new MinecraftKey("killer_bunny");
    public static final int EVIL_ATTACK_POWER = 8;
    public static final int EVIL_ARMOR_VALUE = 8;
    private static final int MORE_CARROTS_DELAY = 40;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int jumpDelayTicks;
    int moreCarrotTicks;

    public EntityRabbit(EntityTypes<? extends EntityRabbit> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.jumpControl = new ControllerJumpRabbit(this);
        this.moveControl = new ControllerMoveRabbit(this);
        this.setSpeedModifier(0.0);
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new ClimbOnTopOfPowderSnowGoal(this, this.level));
        this.goalSelector.addGoal(1, new PathfinderGoalRabbitPanic(this, 2.2));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 0.8));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.0, RecipeItemStack.of(Items.CARROT, Items.GOLDEN_CARROT, Blocks.DANDELION), false));
        this.goalSelector.addGoal(4, new PathfinderGoalRabbitAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 2.2, 2.2));
        this.goalSelector.addGoal(4, new PathfinderGoalRabbitAvoidTarget<EntityWolf>(this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.goalSelector.addGoal(4, new PathfinderGoalRabbitAvoidTarget<EntityMonster>(this, EntityMonster.class, 4.0f, 2.2, 2.2));
        this.goalSelector.addGoal(5, new PathfinderGoalEatCarrots(this));
        this.goalSelector.addGoal(6, new PathfinderGoalRandomStrollLand(this, 0.6));
        this.goalSelector.addGoal(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
    }

    @Override
    protected float getJumpPower() {
        if (this.horizontalCollision || this.moveControl.hasWanted() && this.moveControl.getWantedY() > this.getY() + 0.5) {
            return 0.5f;
        }
        PathEntity var0 = this.navigation.getPath();
        if (var0 != null && !var0.isDone()) {
            Vec3D var1 = var0.getNextEntityPos(this);
            if (var1.y > this.getY() + 0.5) {
                return 0.5f;
            }
        }
        if (this.moveControl.getSpeedModifier() <= 0.6) {
            return 0.2f;
        }
        return 0.3f;
    }

    @Override
    protected void jumpFromGround() {
        double var2;
        super.jumpFromGround();
        double var0 = this.moveControl.getSpeedModifier();
        if (var0 > 0.0 && (var2 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
        if (!this.level.isClientSide) {
            this.level.broadcastEntityEvent(this, (byte)1);
        }
    }

    public float getJumpCompletion(float var0) {
        if (this.jumpDuration == 0) {
            return 0.0f;
        }
        return ((float)this.jumpTicks + var0) / (float)this.jumpDuration;
    }

    public void setSpeedModifier(double var0) {
        this.getNavigation().setSpeedModifier(var0);
        this.moveControl.setWantedPosition(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ(), var0);
    }

    @Override
    public void setJumping(boolean var0) {
        super.setJumping(var0);
        if (var0) {
            this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.setJumping(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_TYPE_ID, 0);
    }

    @Override
    public void customServerAiStep() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.moreCarrotTicks > 0) {
            this.moreCarrotTicks -= this.random.nextInt(3);
            if (this.moreCarrotTicks < 0) {
                this.moreCarrotTicks = 0;
            }
        }
        if (this.onGround) {
            Object var0;
            if (!this.wasOnGround) {
                this.setJumping(false);
                this.checkLandingDelay();
            }
            if (this.getRabbitType() == 99 && this.jumpDelayTicks == 0 && (var0 = this.getTarget()) != null && this.distanceToSqr((Entity)var0) < 16.0) {
                this.facePoint(((Entity)var0).getX(), ((Entity)var0).getZ());
                this.moveControl.setWantedPosition(((Entity)var0).getX(), ((Entity)var0).getY(), ((Entity)var0).getZ(), this.moveControl.getSpeedModifier());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (!((ControllerJumpRabbit)(var0 = (ControllerJumpRabbit)this.jumpControl)).wantJump()) {
                if (this.moveControl.hasWanted() && this.jumpDelayTicks == 0) {
                    PathEntity var1 = this.navigation.getPath();
                    Vec3D var2 = new Vec3D(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ());
                    if (var1 != null && !var1.isDone()) {
                        var2 = var1.getNextEntityPos(this);
                    }
                    this.facePoint(var2.x, var2.z);
                    this.startJumping();
                }
            } else if (!((ControllerJumpRabbit)var0).canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.onGround;
    }

    @Override
    public boolean canSpawnSprintParticle() {
        return false;
    }

    private void facePoint(double var0, double var2) {
        this.setYRot((float)(MathHelper.atan2(var2 - this.getZ(), var0 - this.getX()) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((ControllerJumpRabbit)this.jumpControl).setCanJump(true);
    }

    private void disableJumpControl() {
        ((ControllerJumpRabbit)this.jumpControl).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.moveControl.getSpeedModifier() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 3.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("RabbitType", this.getRabbitType());
        var0.putInt("MoreCarrotTicks", this.moreCarrotTicks);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setRabbitType(var0.getInt("RabbitType"));
        this.moreCarrotTicks = var0.getInt("MoreCarrotTicks");
    }

    protected SoundEffect getJumpSound() {
        return SoundEffects.RABBIT_JUMP;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.RABBIT_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.RABBIT_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.RABBIT_DEATH;
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        if (this.getRabbitType() == 99) {
            this.playSound(SoundEffects.RABBIT_ATTACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            return var0.hurt(DamageSource.mobAttack(this), 8.0f);
        }
        return var0.hurt(DamageSource.mobAttack(this), 3.0f);
    }

    @Override
    public SoundCategory getSoundSource() {
        return this.getRabbitType() == 99 ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL;
    }

    private static boolean isTemptingItem(ItemStack var0) {
        return var0.is(Items.CARROT) || var0.is(Items.GOLDEN_CARROT) || var0.is(Blocks.DANDELION.asItem());
    }

    @Override
    public EntityRabbit getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityRabbit var2 = EntityTypes.RABBIT.create(var0);
        int var3 = this.getRandomRabbitType(var0);
        if (this.random.nextInt(20) != 0) {
            var3 = var1 instanceof EntityRabbit && this.random.nextBoolean() ? ((EntityRabbit)var1).getRabbitType() : this.getRabbitType();
        }
        var2.setRabbitType(var3);
        return var2;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return EntityRabbit.isTemptingItem(var0);
    }

    public int getRabbitType() {
        return this.entityData.get(DATA_TYPE_ID);
    }

    public void setRabbitType(int var0) {
        if (var0 == 99) {
            this.getAttribute(GenericAttributes.ARMOR).setBaseValue(8.0);
            this.goalSelector.addGoal(4, new PathfinderGoalKillerRabbitMeleeAttack(this));
            this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(new Class[0]));
            this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
            this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityWolf>((EntityInsentient)this, EntityWolf.class, true));
            if (!this.hasCustomName()) {
                this.setCustomName(IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("entity", KILLER_BUNNY)));
            }
        }
        this.entityData.set(DATA_TYPE_ID, var0);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        int var5 = this.getRandomRabbitType(var0);
        if (var3 instanceof GroupDataRabbit) {
            var5 = ((GroupDataRabbit)var3).rabbitType;
        } else {
            var3 = new GroupDataRabbit(var5);
        }
        this.setRabbitType(var5);
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    private int getRandomRabbitType(GeneratorAccess var0) {
        Holder<BiomeBase> var1 = var0.getBiome(this.blockPosition());
        int var2 = var0.getRandom().nextInt(100);
        if (var1.value().getPrecipitation() == BiomeBase.Precipitation.SNOW) {
            return var2 < 80 ? 1 : 3;
        }
        if (var1.is(BiomeTags.ONLY_ALLOWS_SNOW_AND_GOLD_RABBITS)) {
            return 4;
        }
        return var2 < 50 ? 0 : (var2 < 90 ? 5 : 2);
    }

    public static boolean checkRabbitSpawnRules(EntityTypes<EntityRabbit> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.RABBITS_SPAWNABLE_ON) && EntityRabbit.isBrightEnoughToSpawn(var1, var3);
    }

    boolean wantsMoreFood() {
        return this.moreCarrotTicks == 0;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 1) {
            this.spawnSprintParticle();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    @Override
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    public static class ControllerJumpRabbit
    extends ControllerJump {
        private final EntityRabbit rabbit;
        private boolean canJump;

        public ControllerJumpRabbit(EntityRabbit var0) {
            super(var0);
            this.rabbit = var0;
        }

        public boolean wantJump() {
            return this.jump;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean var0) {
            this.canJump = var0;
        }

        @Override
        public void tick() {
            if (this.jump) {
                this.rabbit.startJumping();
                this.jump = false;
            }
        }
    }

    static class ControllerMoveRabbit
    extends ControllerMove {
        private final EntityRabbit rabbit;
        private double nextJumpSpeed;

        public ControllerMoveRabbit(EntityRabbit var0) {
            super(var0);
            this.rabbit = var0;
        }

        @Override
        public void tick() {
            if (this.rabbit.onGround && !this.rabbit.jumping && !((ControllerJumpRabbit)this.rabbit.jumpControl).wantJump()) {
                this.rabbit.setSpeedModifier(0.0);
            } else if (this.hasWanted()) {
                this.rabbit.setSpeedModifier(this.nextJumpSpeed);
            }
            super.tick();
        }

        @Override
        public void setWantedPosition(double var0, double var2, double var4, double var6) {
            if (this.rabbit.isInWater()) {
                var6 = 1.5;
            }
            super.setWantedPosition(var0, var2, var4, var6);
            if (var6 > 0.0) {
                this.nextJumpSpeed = var6;
            }
        }
    }

    static class PathfinderGoalRabbitPanic
    extends PathfinderGoalPanic {
        private final EntityRabbit rabbit;

        public PathfinderGoalRabbitPanic(EntityRabbit var0, double var1) {
            super(var0, var1);
            this.rabbit = var0;
        }

        @Override
        public void tick() {
            super.tick();
            this.rabbit.setSpeedModifier(this.speedModifier);
        }
    }

    static class PathfinderGoalRabbitAvoidTarget<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityRabbit rabbit;

        public PathfinderGoalRabbitAvoidTarget(EntityRabbit var0, Class<T> var1, float var2, double var3, double var5) {
            super(var0, var1, var2, var3, var5);
            this.rabbit = var0;
        }

        @Override
        public boolean canUse() {
            return this.rabbit.getRabbitType() != 99 && super.canUse();
        }
    }

    static class PathfinderGoalEatCarrots
    extends PathfinderGoalGotoTarget {
        private final EntityRabbit rabbit;
        private boolean wantsToRaid;
        private boolean canRaid;

        public PathfinderGoalEatCarrots(EntityRabbit var0) {
            super(var0, 0.7f, 16);
            this.rabbit = var0;
        }

        @Override
        public boolean canUse() {
            if (this.nextStartTick <= 0) {
                if (!this.rabbit.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = this.rabbit.wantsMoreFood();
                this.wantsToRaid = true;
            }
            return super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canRaid && super.canContinueToUse();
        }

        @Override
        public void tick() {
            super.tick();
            this.rabbit.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, this.blockPos.getY() + 1, (double)this.blockPos.getZ() + 0.5, 10.0f, this.rabbit.getMaxHeadXRot());
            if (this.isReachedTarget()) {
                World var0 = this.rabbit.level;
                BlockPosition var1 = this.blockPos.above();
                IBlockData var2 = var0.getBlockState(var1);
                Block var3 = var2.getBlock();
                if (this.canRaid && var3 instanceof BlockCarrots) {
                    int var4 = var2.getValue(BlockCarrots.AGE);
                    if (var4 == 0) {
                        var0.setBlock(var1, Blocks.AIR.defaultBlockState(), 2);
                        var0.destroyBlock(var1, true, this.rabbit);
                    } else {
                        var0.setBlock(var1, (IBlockData)var2.setValue(BlockCarrots.AGE, var4 - 1), 2);
                        var0.levelEvent(2001, var1, Block.getId(var2));
                    }
                    this.rabbit.moreCarrotTicks = 40;
                }
                this.canRaid = false;
                this.nextStartTick = 10;
            }
        }

        @Override
        protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
            IBlockData var2 = var0.getBlockState(var1);
            if (var2.is(Blocks.FARMLAND) && this.wantsToRaid && !this.canRaid && (var2 = var0.getBlockState(var1.above())).getBlock() instanceof BlockCarrots && ((BlockCarrots)var2.getBlock()).isMaxAge(var2)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    static class PathfinderGoalKillerRabbitMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalKillerRabbitMeleeAttack(EntityRabbit var0) {
            super(var0, 1.4, true);
        }

        @Override
        protected double getAttackReachSqr(EntityLiving var0) {
            return 4.0f + var0.getBbWidth();
        }
    }

    public static class GroupDataRabbit
    extends EntityAgeable.a {
        public final int rabbitType;

        public GroupDataRabbit(int var0) {
            super(1.0f);
            this.rabbitType = var0;
        }
    }
}

