/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ambient;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class EntityBat
extends EntityAmbient {
    public static final float FLAP_DEGREES_PER_TICK = 74.48451f;
    public static final int TICKS_PER_FLAP = MathHelper.ceil(2.4166098f);
    private static final DataWatcherObject<Byte> DATA_ID_FLAGS = DataWatcher.defineId(EntityBat.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_RESTING = 1;
    private static final PathfinderTargetCondition BAT_RESTING_TARGETING = PathfinderTargetCondition.forNonCombat().range(4.0);
    @Nullable
    private BlockPosition targetPosition;

    public EntityBat(EntityTypes<? extends EntityBat> var0, World var1) {
        super((EntityTypes<? extends EntityAmbient>)var0, var1);
        this.setResting(true);
    }

    @Override
    public boolean isFlapping() {
        return !this.isResting() && this.tickCount % TICKS_PER_FLAP == 0;
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_ID_FLAGS, (byte)0);
    }

    @Override
    protected float getSoundVolume() {
        return 0.1f;
    }

    @Override
    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }

    @Override
    @Nullable
    public SoundEffect getAmbientSound() {
        if (this.isResting() && this.random.nextInt(4) != 0) {
            return null;
        }
        return SoundEffects.BAT_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.BAT_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.BAT_DEATH;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity var0) {
    }

    @Override
    protected void pushEntities() {
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 6.0);
    }

    public boolean isResting() {
        return (this.entityData.get(DATA_ID_FLAGS) & 1) != 0;
    }

    public void setResting(boolean var0) {
        byte var1 = this.entityData.get(DATA_ID_FLAGS);
        if (var0) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var1 | 1));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var1 & 0xFFFFFFFE));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isResting()) {
            this.setDeltaMovement(Vec3D.ZERO);
            this.setPosRaw(this.getX(), (double)MathHelper.floor(this.getY()) + 1.0 - (double)this.getBbHeight(), this.getZ());
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        BlockPosition var0 = this.blockPosition();
        BlockPosition var1 = var0.above();
        if (this.isResting()) {
            boolean var2 = this.isSilent();
            if (this.level.getBlockState(var1).isRedstoneConductor(this.level, var0)) {
                if (this.random.nextInt(200) == 0) {
                    this.yHeadRot = this.random.nextInt(360);
                }
                if (this.level.getNearestPlayer(BAT_RESTING_TARGETING, this) != null) {
                    this.setResting(false);
                    if (!var2) {
                        this.level.levelEvent(null, 1025, var0, 0);
                    }
                }
            } else {
                this.setResting(false);
                if (!var2) {
                    this.level.levelEvent(null, 1025, var0, 0);
                }
            }
        } else {
            if (!(this.targetPosition == null || this.level.isEmptyBlock(this.targetPosition) && this.targetPosition.getY() > this.level.getMinBuildHeight())) {
                this.targetPosition = null;
            }
            if (this.targetPosition == null || this.random.nextInt(30) == 0 || this.targetPosition.closerToCenterThan(this.position(), 2.0)) {
                this.targetPosition = new BlockPosition(this.getX() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7), this.getY() + (double)this.random.nextInt(6) - 2.0, this.getZ() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7));
            }
            double var2 = (double)this.targetPosition.getX() + 0.5 - this.getX();
            double var4 = (double)this.targetPosition.getY() + 0.1 - this.getY();
            double var6 = (double)this.targetPosition.getZ() + 0.5 - this.getZ();
            Vec3D var8 = this.getDeltaMovement();
            Vec3D var9 = var8.add((Math.signum(var2) * 0.5 - var8.x) * (double)0.1f, (Math.signum(var4) * (double)0.7f - var8.y) * (double)0.1f, (Math.signum(var6) * 0.5 - var8.z) * (double)0.1f);
            this.setDeltaMovement(var9);
            float var10 = (float)(MathHelper.atan2(var9.z, var9.x) * 57.2957763671875) - 90.0f;
            float var11 = MathHelper.wrapDegrees(var10 - this.getYRot());
            this.zza = 0.5f;
            this.setYRot(this.getYRot() + var11);
            if (this.random.nextInt(100) == 0 && this.level.getBlockState(var1).isRedstoneConductor(this.level, var1)) {
                this.setResting(true);
            }
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        return false;
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        if (!this.level.isClientSide && this.isResting()) {
            this.setResting(false);
        }
        return super.hurt(var0, var1);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.entityData.set(DATA_ID_FLAGS, var0.getByte("BatFlags"));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putByte("BatFlags", this.entityData.get(DATA_ID_FLAGS));
    }

    public static boolean checkBatSpawnRules(EntityTypes<EntityBat> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        if (var3.getY() >= var1.getSeaLevel()) {
            return false;
        }
        int var5 = var1.getMaxLocalRawBrightness(var3);
        int var6 = 4;
        if (EntityBat.isHalloween()) {
            var6 = 7;
        } else if (var4.nextBoolean()) {
            return false;
        }
        if (var5 > var4.nextInt(var6)) {
            return false;
        }
        return EntityBat.checkMobSpawnRules(var0, var1, var2, var3, var4);
    }

    private static boolean isHalloween() {
        LocalDate var0 = LocalDate.now();
        int var1 = var0.get(ChronoField.DAY_OF_MONTH);
        int var2 = var0.get(ChronoField.MONTH_OF_YEAR);
        return var2 == 10 && var1 >= 20 || var2 == 11 && var1 <= 3;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height / 2.0f;
    }
}

