/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;

public class SensorHoglinSpecific
extends Sensor<EntityHoglin> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, (Object[])new MemoryModuleType[0]);
    }

    @Override
    protected void doTick(WorldServer var02, EntityHoglin var1) {
        BehaviorController<EntityHoglin> var2 = var1.getBrain();
        var2.setMemory(MemoryModuleType.NEAREST_REPELLENT, this.findNearestRepellent(var02, var1));
        Optional<Object> var3 = Optional.empty();
        int var4 = 0;
        ArrayList var5 = Lists.newArrayList();
        NearestVisibleLivingEntities var6 = var2.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        for (EntityLiving var8 : var6.findAll(var0 -> !var0.isBaby() && (var0 instanceof EntityPiglin || var0 instanceof EntityHoglin))) {
            EntityCreature var9;
            if (var8 instanceof EntityPiglin) {
                var9 = (EntityPiglin)var8;
                ++var4;
                if (var3.isEmpty()) {
                    var3 = Optional.of(var9);
                }
            }
            if (!(var8 instanceof EntityHoglin)) continue;
            var9 = (EntityHoglin)var8;
            var5.add(var9);
        }
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, var3);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS, var5);
        var2.setMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, var4);
        var2.setMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, var5.size());
    }

    private Optional<BlockPosition> findNearestRepellent(WorldServer var0, EntityHoglin var12) {
        return BlockPosition.findClosestMatch(var12.blockPosition(), 8, 4, var1 -> var0.getBlockState((BlockPosition)var1).is(TagsBlock.HOGLIN_REPELLENTS));
    }
}

