/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.memory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.VisibleForDebug;

public class ExpirableMemory<T> {
    private final T value;
    private long timeToLive;

    public ExpirableMemory(T var0, long var1) {
        this.value = var0;
        this.timeToLive = var1;
    }

    public void tick() {
        if (this.canExpire()) {
            --this.timeToLive;
        }
    }

    public static <T> ExpirableMemory<T> of(T var0) {
        return new ExpirableMemory<T>(var0, Long.MAX_VALUE);
    }

    public static <T> ExpirableMemory<T> of(T var0, long var1) {
        return new ExpirableMemory<T>(var0, var1);
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public T getValue() {
        return this.value;
    }

    public boolean hasExpired() {
        return this.timeToLive <= 0L;
    }

    public String toString() {
        return this.value + (String)(this.canExpire() ? " (ttl: " + this.timeToLive + ")" : "");
    }

    @VisibleForDebug
    public boolean canExpire() {
        return this.timeToLive != Long.MAX_VALUE;
    }

    public static <T> Codec<ExpirableMemory<T>> codec(Codec<T> var0) {
        return RecordCodecBuilder.create(var12 -> var12.group((App)var0.fieldOf("value").forGetter(var0 -> var0.value), (App)Codec.LONG.optionalFieldOf("ttl").forGetter(var0 -> var0.canExpire() ? Optional.of(var0.timeToLive) : Optional.empty())).apply((Applicative)var12, (var0, var1) -> new ExpirableMemory<Object>(var0, var1.orElse(Long.MAX_VALUE))));
    }
}

