/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;

public class PathfinderGoalTradeWithPlayer
extends PathfinderGoal {
    private final EntityVillagerAbstract mob;

    public PathfinderGoalTradeWithPlayer(EntityVillagerAbstract var0) {
        this.mob = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.JUMP, PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canUse() {
        if (!this.mob.isAlive()) {
            return false;
        }
        if (this.mob.isInWater()) {
            return false;
        }
        if (!this.mob.isOnGround()) {
            return false;
        }
        if (this.mob.hurtMarked) {
            return false;
        }
        EntityHuman var0 = this.mob.getTradingPlayer();
        if (var0 == null) {
            return false;
        }
        if (this.mob.distanceToSqr(var0) > 16.0) {
            return false;
        }
        return var0.containerMenu != null;
    }

    @Override
    public void start() {
        this.mob.getNavigation().stop();
    }

    @Override
    public void stop() {
        this.mob.setTradingPlayer(null);
    }
}

