/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenAi;

public class Sniffing<E extends Warden>
extends Behavior<E> {
    private static final double ANGER_FROM_SNIFFING_MAX_DISTANCE_XZ = 6.0;
    private static final double ANGER_FROM_SNIFFING_MAX_DISTANCE_Y = 20.0;

    public Sniffing(int var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.IS_SNIFFING, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.NEAREST_ATTACKABLE, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.DISTURBANCE_LOCATION, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.SNIFF_COOLDOWN, (Object)((Object)MemoryStatus.REGISTERED)), var0);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, E var1, long var2) {
        return true;
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        ((Entity)var1).playSound(SoundEffects.WARDEN_SNIFF, 5.0f, 1.0f);
    }

    @Override
    protected void stop(WorldServer var0, E var12, long var2) {
        if (((Entity)var12).hasPose(EntityPose.SNIFFING)) {
            ((Entity)var12).setPose(EntityPose.STANDING);
        }
        ((Warden)var12).getBrain().eraseMemory(MemoryModuleType.IS_SNIFFING);
        ((Warden)var12).getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE).filter(arg_0 -> var12.canTargetEntity(arg_0)).ifPresent(var1 -> {
            if (var12.closerThan((Entity)var1, 6.0, 20.0)) {
                var12.increaseAngerAt((Entity)var1);
            }
            if (!var12.getBrain().hasMemoryValue(MemoryModuleType.DISTURBANCE_LOCATION)) {
                WardenAi.setDisturbanceLocation(var12, var1.blockPosition());
            }
        });
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (E)((Warden)entityLiving), l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (E)((Warden)entityLiving), l2);
    }
}

