/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;

public class SetRoarTarget<E extends Warden>
extends Behavior<E> {
    private final Function<E, Optional<? extends EntityLiving>> targetFinderFunction;

    public SetRoarTarget(Function<E, Optional<? extends EntityLiving>> var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ROAR_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)((Object)MemoryStatus.REGISTERED)));
        this.targetFinderFunction = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return this.targetFinderFunction.apply(var1).filter(arg_0 -> var1.canTargetEntity(arg_0)).isPresent();
    }

    @Override
    protected void start(WorldServer var0, E var12, long var2) {
        this.targetFinderFunction.apply(var12).ifPresent(var1 -> {
            var12.getBrain().setMemory(MemoryModuleType.ROAR_TARGET, var1);
            var12.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        });
    }
}

