/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;

public class Digging<E extends Warden>
extends Behavior<E> {
    public Digging(int var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), var0);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, E var1, long var2) {
        return ((Entity)var1).getRemovalReason() == null;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return ((Entity)var1).isOnGround() || ((Entity)var1).isInWater() || ((Entity)var1).isInLava();
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        if (((Entity)var1).isOnGround()) {
            ((Entity)var1).setPose(EntityPose.DIGGING);
            ((Entity)var1).playSound(SoundEffects.WARDEN_DIG, 5.0f, 1.0f);
        } else {
            ((Entity)var1).playSound(SoundEffects.WARDEN_AGITATED, 5.0f, 1.0f);
            this.stop(var0, var1, var2);
        }
    }

    @Override
    protected void stop(WorldServer var0, E var1, long var2) {
        if (((Entity)var1).getRemovalReason() == null) {
            ((Entity)var1).remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (E)((Warden)entityLiving), l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (E)((Warden)entityLiving), l2);
    }
}

