/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class TryFindLand
extends Behavior<EntityCreature> {
    private static final int COOLDOWN_TICKS = 60;
    private final int range;
    private final float speedModifier;
    private long nextOkStartTime;

    public TryFindLand(int var0, float var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
        this.range = var0;
        this.speedModifier = var1;
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        this.nextOkStartTime = var2 + 60L;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return var1.level.getFluidState(var1.blockPosition()).is(TagsFluid.WATER);
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        if (var2 < this.nextOkStartTime) {
            return;
        }
        BlockPosition var4 = var1.blockPosition();
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        VoxelShapeCollision var6 = VoxelShapeCollision.of(var1);
        for (BlockPosition var8 : BlockPosition.withinManhattan(var4, this.range, this.range, this.range)) {
            if (var8.getX() == var4.getX() && var8.getZ() == var4.getZ()) continue;
            IBlockData var9 = var0.getBlockState(var8);
            IBlockData var10 = var0.getBlockState(var5.setWithOffset((BaseBlockPosition)var8, EnumDirection.DOWN));
            if (var9.is(Blocks.WATER) || !var0.getFluidState(var8).isEmpty() || !var9.getCollisionShape(var0, var8, var6).isEmpty() || !var10.isFaceSturdy(var0, var5, EnumDirection.UP)) continue;
            this.nextOkStartTime = var2 + 60L;
            BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var1, var8.immutable(), this.speedModifier, 1);
            return;
        }
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }
}

