/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;

public class BehaviorWalkAway<T>
extends Behavior<EntityCreature> {
    private final MemoryModuleType<T> walkAwayFromMemory;
    private final float speedModifier;
    private final int desiredDistance;
    private final Function<T, Vec3D> toPosition;

    public BehaviorWalkAway(MemoryModuleType<T> var0, float var1, int var2, boolean var3, Function<T, Vec3D> var4) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)(var3 ? MemoryStatus.REGISTERED : MemoryStatus.VALUE_ABSENT)), var0, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.walkAwayFromMemory = var0;
        this.speedModifier = var1;
        this.desiredDistance = var2;
        this.toPosition = var4;
    }

    public static BehaviorWalkAway<BlockPosition> pos(MemoryModuleType<BlockPosition> var0, float var1, int var2, boolean var3) {
        return new BehaviorWalkAway<BlockPosition>(var0, var1, var2, var3, Vec3D::atBottomCenterOf);
    }

    public static BehaviorWalkAway<? extends Entity> entity(MemoryModuleType<? extends Entity> var0, float var1, int var2, boolean var3) {
        return new BehaviorWalkAway<Entity>(var0, var1, var2, var3, Entity::position);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        if (this.alreadyWalkingAwayFromPosWithSameSpeed(var1)) {
            return false;
        }
        return var1.position().closerThan(this.getPosToAvoid(var1), this.desiredDistance);
    }

    private Vec3D getPosToAvoid(EntityCreature var0) {
        return this.toPosition.apply(var0.getBrain().getMemory(this.walkAwayFromMemory).get());
    }

    private boolean alreadyWalkingAwayFromPosWithSameSpeed(EntityCreature var0) {
        Vec3D var3;
        if (!var0.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET)) {
            return false;
        }
        MemoryTarget var1 = var0.getBrain().getMemory(MemoryModuleType.WALK_TARGET).get();
        if (var1.getSpeedModifier() != this.speedModifier) {
            return false;
        }
        Vec3D var2 = var1.getTarget().currentPosition().subtract(var0.position());
        return var2.dot(var3 = this.getPosToAvoid(var0).subtract(var0.position())) < 0.0;
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        BehaviorWalkAway.moveAwayFrom(var1, this.getPosToAvoid(var1), this.speedModifier);
    }

    private static void moveAwayFrom(EntityCreature var0, Vec3D var1, float var2) {
        for (int var3 = 0; var3 < 10; ++var3) {
            Vec3D var4 = LandRandomPos.getPosAway(var0, 16, 7, var1);
            if (var4 == null) continue;
            var0.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var4, var2, 0));
            return;
        }
    }
}

