/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import net.minecraft.server.level.WorldServer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;

public class BehaviorRunSometimes<E extends EntityLiving>
extends Behavior<E> {
    private boolean resetTicks;
    private boolean wasRunning;
    private final UniformInt interval;
    private final Behavior<? super E> wrappedBehavior;
    private int ticksUntilNextStart;

    public BehaviorRunSometimes(Behavior<? super E> var0, UniformInt var1) {
        this(var0, false, var1);
    }

    public BehaviorRunSometimes(Behavior<? super E> var0, boolean var1, UniformInt var2) {
        super(var0.entryCondition);
        this.wrappedBehavior = var0;
        this.resetTicks = !var1;
        this.interval = var2;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        if (!this.wrappedBehavior.checkExtraStartConditions(var0, var1)) {
            return false;
        }
        if (this.resetTicks) {
            this.resetTicksUntilNextStart(var0);
            this.resetTicks = false;
        }
        if (this.ticksUntilNextStart > 0) {
            --this.ticksUntilNextStart;
        }
        return !this.wasRunning && this.ticksUntilNextStart == 0;
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        this.wrappedBehavior.start(var0, var1, var2);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, E var1, long var2) {
        return this.wrappedBehavior.canStillUse(var0, var1, var2);
    }

    @Override
    protected void tick(WorldServer var0, E var1, long var2) {
        this.wrappedBehavior.tick(var0, var1, var2);
        this.wasRunning = this.wrappedBehavior.getStatus() == Behavior.Status.RUNNING;
    }

    @Override
    protected void stop(WorldServer var0, E var1, long var2) {
        this.resetTicksUntilNextStart(var0);
        this.wrappedBehavior.stop(var0, var1, var2);
    }

    private void resetTicksUntilNextStart(WorldServer var0) {
        this.ticksUntilNextStart = this.interval.sample(var0.random);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    public String toString() {
        return "RunSometimes: " + this.wrappedBehavior;
    }
}

