/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.schedule.Activity;

public class BehaviorPanic
extends Behavior<EntityVillager> {
    public BehaviorPanic() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return BehaviorPanic.isHurt(var1) || BehaviorPanic.hasHostile(var1);
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        if (BehaviorPanic.isHurt(var1) || BehaviorPanic.hasHostile(var1)) {
            BehaviorController<EntityVillager> var4 = var1.getBrain();
            if (!var4.isActive(Activity.PANIC)) {
                var4.eraseMemory(MemoryModuleType.PATH);
                var4.eraseMemory(MemoryModuleType.WALK_TARGET);
                var4.eraseMemory(MemoryModuleType.LOOK_TARGET);
                var4.eraseMemory(MemoryModuleType.BREED_TARGET);
                var4.eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            }
            var4.setActiveActivityIfPossible(Activity.PANIC);
        }
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        if (var2 % 100L == 0L) {
            var1.spawnGolemIfNeeded(var0, var2, 3);
        }
    }

    public static boolean hasHostile(EntityLiving var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_HOSTILE);
    }

    public static boolean isHurt(EntityLiving var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityVillager)entityLiving, l2);
    }
}

