/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorOutside;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemFireworks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BehaviorCelebrate
extends Behavior<EntityVillager> {
    @Nullable
    private Raid currentRaid;

    public BehaviorCelebrate(int var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), var0, var1);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        BlockPosition var2 = var1.blockPosition();
        this.currentRaid = var0.getRaidAt(var2);
        return this.currentRaid != null && this.currentRaid.isVictory() && BehaviorOutside.hasNoBlocksAbove(var0, var1, var2);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return this.currentRaid != null && !this.currentRaid.isStopped();
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        this.currentRaid = null;
        var1.getBrain().updateActivityFromSchedule(var0.getDayTime(), var0.getGameTime());
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        RandomSource var4 = var1.getRandom();
        if (var4.nextInt(100) == 0) {
            var1.playCelebrateSound();
        }
        if (var4.nextInt(200) == 0 && BehaviorOutside.hasNoBlocksAbove(var0, var1, var1.blockPosition())) {
            EnumColor var5 = SystemUtils.getRandom(EnumColor.values(), var4);
            int var6 = var4.nextInt(3);
            ItemStack var7 = this.getFirework(var5, var6);
            EntityFireworks var8 = new EntityFireworks(var1.level, var1, var1.getX(), var1.getEyeY(), var1.getZ(), var7);
            var1.level.addFreshEntity(var8);
        }
    }

    private ItemStack getFirework(EnumColor var0, int var1) {
        ItemStack var2 = new ItemStack(Items.FIREWORK_ROCKET, 1);
        ItemStack var3 = new ItemStack(Items.FIREWORK_STAR);
        NBTTagCompound var4 = var3.getOrCreateTagElement("Explosion");
        ArrayList var5 = Lists.newArrayList();
        var5.add(var0.getFireworkColor());
        var4.putIntArray("Colors", var5);
        var4.putByte("Type", (byte)ItemFireworks.EffectType.BURST.getId());
        NBTTagCompound var6 = var2.getOrCreateTagElement("Fireworks");
        NBTTagList var7 = new NBTTagList();
        NBTTagCompound var8 = var3.getTagElement("Explosion");
        if (var8 != null) {
            var7.add(var8);
        }
        var6.putByte("Flight", (byte)var1);
        if (!var7.isEmpty()) {
            var6.put("Explosions", var7);
        }
        return var2;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (EntityVillager)entityLiving, l2);
    }
}

