/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;

public class BehaviorBell
extends Behavior<EntityLiving> {
    private static final float SPEED_MODIFIER = 0.3f;

    public BehaviorBell() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.MEETING_POINT, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var02, EntityLiving var1) {
        BehaviorController<?> var2 = var1.getBrain();
        Optional<GlobalPos> var3 = var2.getMemory(MemoryModuleType.MEETING_POINT);
        return var02.getRandom().nextInt(100) == 0 && var3.isPresent() && var02.dimension() == var3.get().dimension() && var3.get().pos().closerToCenterThan(var1.position(), 4.0) && var2.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().contains(var0 -> EntityTypes.VILLAGER.equals(var0.getType()));
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var13, long var2) {
        BehaviorController<?> var4 = var13.getBrain();
        var4.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(var12 -> var12.findClosest(var1 -> EntityTypes.VILLAGER.equals(var1.getType()) && var1.distanceToSqr(var13) <= 32.0)).ifPresent(var1 -> {
            var4.setMemory(MemoryModuleType.INTERACTION_TARGET, var1);
            var4.setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity((Entity)var1, true));
            var4.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorPositionEntity((Entity)var1, false), 0.3f, 1));
        });
    }
}

