/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;

public class BehaviorAttack
extends Behavior<EntityInsentient> {
    private final int cooldownBetweenAttacks;

    public BehaviorAttack(int var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ATTACK_COOLING_DOWN, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.cooldownBetweenAttacks = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityInsentient var1) {
        EntityLiving var2 = this.getAttackTarget(var1);
        return !this.isHoldingUsableProjectileWeapon(var1) && BehaviorUtil.canSee(var1, var2) && var1.isWithinMeleeAttackRange(var2);
    }

    private boolean isHoldingUsableProjectileWeapon(EntityInsentient var0) {
        return var0.isHolding(var1 -> {
            Item var2 = var1.getItem();
            return var2 instanceof ItemProjectileWeapon && var0.canFireProjectileWeapon((ItemProjectileWeapon)var2);
        });
    }

    @Override
    protected void start(WorldServer var0, EntityInsentient var1, long var2) {
        EntityLiving var4 = this.getAttackTarget(var1);
        BehaviorUtil.lookAtEntity(var1, var4);
        var1.swing(EnumHand.MAIN_HAND);
        var1.doHurtTarget(var4);
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, true, this.cooldownBetweenAttacks);
    }

    private EntityLiving getAttackTarget(EntityInsentient var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }
}

