/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeProvider {
    private final Map<AttributeBase, AttributeModifiable> instances;

    public AttributeProvider(Map<AttributeBase, AttributeModifiable> var0) {
        this.instances = ImmutableMap.copyOf(var0);
    }

    private AttributeModifiable getAttributeInstance(AttributeBase var0) {
        AttributeModifiable var1 = this.instances.get(var0);
        if (var1 == null) {
            throw new IllegalArgumentException("Can't find attribute " + IRegistry.ATTRIBUTE.getKey(var0));
        }
        return var1;
    }

    public double getValue(AttributeBase var0) {
        return this.getAttributeInstance(var0).getValue();
    }

    public double getBaseValue(AttributeBase var0) {
        return this.getAttributeInstance(var0).getBaseValue();
    }

    public double getModifierValue(AttributeBase var0, UUID var1) {
        AttributeModifier var2 = this.getAttributeInstance(var0).getModifier(var1);
        if (var2 == null) {
            throw new IllegalArgumentException("Can't find modifier " + var1 + " on attribute " + IRegistry.ATTRIBUTE.getKey(var0));
        }
        return var2.getAmount();
    }

    @Nullable
    public AttributeModifiable createInstance(Consumer<AttributeModifiable> var0, AttributeBase var1) {
        AttributeModifiable var2 = this.instances.get(var1);
        if (var2 == null) {
            return null;
        }
        AttributeModifiable var3 = new AttributeModifiable(var1, var0);
        var3.replaceFrom(var2);
        return var3;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasAttribute(AttributeBase var0) {
        return this.instances.containsKey(var0);
    }

    public boolean hasModifier(AttributeBase var0, UUID var1) {
        AttributeModifiable var2 = this.instances.get(var0);
        return var2 != null && var2.getModifier(var1) != null;
    }

    public static class Builder {
        private final Map<AttributeBase, AttributeModifiable> builder = Maps.newHashMap();
        private boolean instanceFrozen;

        private AttributeModifiable create(AttributeBase var0) {
            AttributeModifiable var12 = new AttributeModifiable(var0, var1 -> {
                if (this.instanceFrozen) {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance: " + IRegistry.ATTRIBUTE.getKey(var0));
                }
            });
            this.builder.put(var0, var12);
            return var12;
        }

        public Builder add(AttributeBase var0) {
            this.create(var0);
            return this;
        }

        public Builder add(AttributeBase var0, double var1) {
            AttributeModifiable var3 = this.create(var0);
            var3.setBaseValue(var1);
            return this;
        }

        public AttributeProvider build() {
            this.instanceFrozen = true;
            return new AttributeProvider(this.builder);
        }
    }
}

