/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ClampedNormalInt
extends IntProvider {
    public static final Codec<ClampedNormalInt> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.FLOAT.fieldOf("mean").forGetter(var0 -> Float.valueOf(var0.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(var0 -> Float.valueOf(var0.deviation)), (App)Codec.INT.fieldOf("min_inclusive").forGetter(var0 -> var0.min_inclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(var0 -> var0.max_inclusive)).apply((Applicative)var02, ClampedNormalInt::new)).comapFlatMap(var0 -> {
        if (var0.max_inclusive < var0.min_inclusive) {
            return DataResult.error((String)("Max must be larger than min: [" + var0.min_inclusive + ", " + var0.max_inclusive + "]"));
        }
        return DataResult.success((Object)var0);
    }, Function.identity());
    private float mean;
    private float deviation;
    private int min_inclusive;
    private int max_inclusive;

    public static ClampedNormalInt of(float var0, float var1, int var2, int var3) {
        return new ClampedNormalInt(var0, var1, var2, var3);
    }

    private ClampedNormalInt(float var0, float var1, int var2, int var3) {
        this.mean = var0;
        this.deviation = var1;
        this.min_inclusive = var2;
        this.max_inclusive = var3;
    }

    @Override
    public int sample(RandomSource var0) {
        return ClampedNormalInt.sample(var0, this.mean, this.deviation, this.min_inclusive, this.max_inclusive);
    }

    public static int sample(RandomSource var0, float var1, float var2, float var3, float var4) {
        return (int)MathHelper.clamp(MathHelper.normal(var0, var1, var2), var3, var4);
    }

    @Override
    public int getMinValue() {
        return this.min_inclusive;
    }

    @Override
    public int getMaxValue() {
        return this.max_inclusive;
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.CLAMPED_NORMAL;
    }

    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.min_inclusive + "-" + this.max_inclusive + "]";
    }
}

