/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class SpawnUtil {
    public static <T extends EntityInsentient> Optional<T> trySpawnMob(EntityTypes<T> var0, EnumMobSpawn var1, WorldServer var2, BlockPosition var3, int var4, int var5, int var6, a var7) {
        BlockPosition.MutableBlockPosition var8 = var3.mutable();
        for (int var9 = 0; var9 < var4; ++var9) {
            EntityInsentient var12;
            int var10 = MathHelper.randomBetweenInclusive(var2.random, -var5, var5);
            int var11 = MathHelper.randomBetweenInclusive(var2.random, -var5, var5);
            var8.setWithOffset(var3, var10, var6, var11);
            if (!var2.getWorldBorder().isWithinBounds(var8) || !SpawnUtil.moveToPossibleSpawnPosition(var2, var6, var8, var7) || (var12 = (EntityInsentient)var0.create(var2, null, null, null, var8, var1, false, false)) == null) continue;
            if (var12.checkSpawnRules(var2, var1) && var12.checkSpawnObstruction(var2)) {
                var2.addFreshEntityWithPassengers(var12);
                return Optional.of(var12);
            }
            var12.discard();
        }
        return Optional.empty();
    }

    private static boolean moveToPossibleSpawnPosition(WorldServer var0, int var1, BlockPosition.MutableBlockPosition var2, a var3) {
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition().set(var2);
        IBlockData var5 = var0.getBlockState(var4);
        for (int var6 = var1; var6 >= -var1; --var6) {
            var2.move(EnumDirection.DOWN);
            var4.setWithOffset((BaseBlockPosition)var2, EnumDirection.UP);
            IBlockData var7 = var0.getBlockState(var2);
            if (var3.canSpawnOn(var0, var2, var7, var4, var5)) {
                var2.move(EnumDirection.UP);
                return true;
            }
            var5 = var7;
        }
        return false;
    }

    public static interface a {
        public static final a LEGACY_IRON_GOLEM = (var0, var1, var2, var3, var4) -> (var4.isAir() || var4.getMaterial().isLiquid()) && var2.getMaterial().isSolidBlocking();
        public static final a ON_TOP_OF_COLLIDER = (var0, var1, var2, var3, var4) -> var4.getCollisionShape(var0, var3).isEmpty() && Block.isFaceFull(var2.getCollisionShape(var0, var1), EnumDirection.UP);

        public boolean canSpawnOn(WorldServer var1, BlockPosition var2, IBlockData var3, BlockPosition var4, IBlockData var5);
    }
}

