/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class DebugBuffer<T> {
    private final AtomicReferenceArray<T> data;
    private final AtomicInteger index;

    public DebugBuffer(int var0) {
        this.data = new AtomicReferenceArray(var0);
        this.index = new AtomicInteger(0);
    }

    public void push(T var0) {
        int var3;
        int var2;
        int var1 = this.data.length();
        while (!this.index.compareAndSet(var2 = this.index.get(), var3 = (var2 + 1) % var1)) {
        }
        this.data.set(var3, var0);
    }

    public List<T> dump() {
        int var0 = this.index.get();
        ImmutableList.Builder var1 = ImmutableList.builder();
        for (int var2 = 0; var2 < this.data.length(); ++var2) {
            int var3 = Math.floorMod(var0 - var2, this.data.length());
            T var4 = this.data.get(var3);
            if (var4 == null) continue;
            var1.add(var4);
        }
        return var1.build();
    }
}

