/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import org.slf4j.Logger;

public class TagDataPack<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    final Function<MinecraftKey, Optional<T>> idToValue;
    private final String directory;

    public TagDataPack(Function<MinecraftKey, Optional<T>> var0, String var1) {
        this.idToValue = var0;
        this.directory = var1;
    }

    public Map<MinecraftKey, List<a>> load(IResourceManager var02) {
        HashMap var1 = Maps.newHashMap();
        for (Map.Entry<MinecraftKey, List<IResource>> var3 : var02.listResourceStacks(this.directory, var0 -> var0.getPath().endsWith(PATH_SUFFIX)).entrySet()) {
            MinecraftKey var4 = var3.getKey();
            String var5 = var4.getPath();
            MinecraftKey var6 = new MinecraftKey(var4.getNamespace(), var5.substring(this.directory.length() + 1, var5.length() - PATH_SUFFIX_LENGTH));
            for (IResource var8 : var3.getValue()) {
                try {
                    BufferedReader var9 = var8.openAsReader();
                    try {
                        JsonElement var10 = JsonParser.parseReader((Reader)var9);
                        List var11 = var1.computeIfAbsent(var6, var0 -> new ArrayList());
                        TagFile var12 = (TagFile)TagFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)var10)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                        if (var12.replace()) {
                            var11.clear();
                        }
                        String var13 = var8.sourcePackId();
                        var12.entries().forEach(var2 -> var11.add(new a((TagEntry)var2, var13)));
                    }
                    finally {
                        if (var9 == null) continue;
                        ((Reader)var9).close();
                    }
                }
                catch (Exception var9) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{var6, var4, var8.sourcePackId(), var9});
                }
            }
        }
        return var1;
    }

    private static void visitDependenciesAndElement(Map<MinecraftKey, List<a>> var0, Multimap<MinecraftKey, MinecraftKey> var1, Set<MinecraftKey> var2, MinecraftKey var3, BiConsumer<MinecraftKey, List<a>> var42) {
        if (!var2.add(var3)) {
            return;
        }
        var1.get((Object)var3).forEach(var4 -> TagDataPack.visitDependenciesAndElement(var0, var1, var2, var4, var42));
        List<a> var5 = var0.get(var3);
        if (var5 != null) {
            var42.accept(var3, var5);
        }
    }

    private static boolean isCyclic(Multimap<MinecraftKey, MinecraftKey> var0, MinecraftKey var1, MinecraftKey var22) {
        Collection var3 = var0.get((Object)var22);
        if (var3.contains(var1)) {
            return true;
        }
        return var3.stream().anyMatch(var2 -> TagDataPack.isCyclic(var0, var1, var2));
    }

    private static void addDependencyIfNotCyclic(Multimap<MinecraftKey, MinecraftKey> var0, MinecraftKey var1, MinecraftKey var2) {
        if (!TagDataPack.isCyclic(var0, var1, var2)) {
            var0.put((Object)var1, (Object)var2);
        }
    }

    private Either<Collection<a>, Collection<T>> build(TagEntry.a<T> var0, List<a> var1) {
        ImmutableSet.Builder var2 = ImmutableSet.builder();
        ArrayList<a> var3 = new ArrayList<a>();
        for (a var5 : var1) {
            if (var5.entry().build(var0, arg_0 -> ((ImmutableSet.Builder)var2).add(arg_0))) continue;
            var3.add(var5);
        }
        return var3.isEmpty() ? Either.right((Object)var2.build()) : Either.left(var3);
    }

    public Map<MinecraftKey, Collection<T>> build(Map<MinecraftKey, List<a>> var0) {
        final HashMap var1 = Maps.newHashMap();
        TagEntry.a var2 = new TagEntry.a<T>(){

            @Override
            @Nullable
            public T element(MinecraftKey var0) {
                return TagDataPack.this.idToValue.apply(var0).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(MinecraftKey var0) {
                return (Collection)var1.get(var0);
            }
        };
        HashMultimap var3 = HashMultimap.create();
        var0.forEach((arg_0, arg_1) -> TagDataPack.b((Multimap)var3, arg_0, arg_1));
        var0.forEach((arg_0, arg_1) -> TagDataPack.a((Multimap)var3, arg_0, arg_1));
        HashSet var4 = Sets.newHashSet();
        var0.keySet().forEach(arg_0 -> this.a(var0, (Multimap)var3, var4, var2, var1, arg_0));
        return var1;
    }

    public Map<MinecraftKey, Collection<T>> loadAndBuild(IResourceManager var0) {
        return this.build(this.load(var0));
    }

    private /* synthetic */ void a(Map var0, Multimap var1, Set var2, TagEntry.a var32, Map var4, MinecraftKey var5) {
        TagDataPack.visitDependenciesAndElement(var0, (Multimap<MinecraftKey, MinecraftKey>)var1, var2, var5, (var22, var3) -> this.build(var32, (List<a>)var3).ifLeft(var1 -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", var22, (Object)var1.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(var2 -> var4.put(var22, var2)));
    }

    private static /* synthetic */ void a(Multimap var0, MinecraftKey var1, List var2) {
        var2.forEach(var22 -> var22.entry.visitOptionalDependencies(var2 -> TagDataPack.addDependencyIfNotCyclic((Multimap<MinecraftKey, MinecraftKey>)var0, var1, var2)));
    }

    private static /* synthetic */ void b(Multimap var0, MinecraftKey var1, List var2) {
        var2.forEach(var22 -> var22.entry.visitRequiredDependencies(var2 -> TagDataPack.addDependencyIfNotCyclic((Multimap<MinecraftKey, MinecraftKey>)var0, var1, var2)));
    }

    public static final class a
    extends Record {
        final TagEntry entry;
        private final String source;

        public a(TagEntry var0, String var1) {
            this.entry = var0;
            this.source = var1;
        }

        @Override
        public String toString() {
            return this.entry + " (from " + this.source + ")";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "entry;source", "entry", "source"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "entry;source", "entry", "source"}, this, var0);
        }

        public TagEntry entry() {
            return this.entry;
        }

        public String source() {
            return this.source;
        }
    }
}

