/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;

public class ResourcePackRepository {
    private final Set<ResourcePackSource> sources;
    private Map<String, ResourcePackLoader> available = ImmutableMap.of();
    private List<ResourcePackLoader> selected = ImmutableList.of();
    private final ResourcePackLoader.a constructor;

    public ResourcePackRepository(ResourcePackLoader.a var0, ResourcePackSource ... var1) {
        this.constructor = var0;
        this.sources = ImmutableSet.copyOf((Object[])var1);
    }

    public ResourcePackRepository(EnumResourcePackType var0, ResourcePackSource ... var12) {
        this((String var1, IChatBaseComponent var2, boolean var3, Supplier<IResourcePack> var4, ResourcePackInfo var5, ResourcePackLoader.Position var6, PackSource var7) -> new ResourcePackLoader(var1, var2, var3, var4, var5, var0, var6, var7), var12);
    }

    public void reload() {
        List var0 = (List)this.selected.stream().map(ResourcePackLoader::getId).collect(ImmutableList.toImmutableList());
        this.available = this.discoverAvailable();
        this.selected = this.rebuildSelected(var0);
    }

    private Map<String, ResourcePackLoader> discoverAvailable() {
        TreeMap var0 = Maps.newTreeMap();
        for (ResourcePackSource var2 : this.sources) {
            var2.loadPacks(var1 -> var0.put(var1.getId(), var1), this.constructor);
        }
        return ImmutableMap.copyOf((Map)var0);
    }

    public void setSelected(Collection<String> var0) {
        this.selected = this.rebuildSelected(var0);
    }

    private List<ResourcePackLoader> rebuildSelected(Collection<String> var0) {
        List var1 = this.getAvailablePacks(var0).collect(Collectors.toList());
        for (ResourcePackLoader var3 : this.available.values()) {
            if (!var3.isRequired() || var1.contains(var3)) continue;
            var3.getDefaultPosition().insert(var1, var3, Functions.identity(), false);
        }
        return ImmutableList.copyOf(var1);
    }

    private Stream<ResourcePackLoader> getAvailablePacks(Collection<String> var0) {
        return var0.stream().map(this.available::get).filter(Objects::nonNull);
    }

    public Collection<String> getAvailableIds() {
        return this.available.keySet();
    }

    public Collection<ResourcePackLoader> getAvailablePacks() {
        return this.available.values();
    }

    public Collection<String> getSelectedIds() {
        return (Collection)this.selected.stream().map(ResourcePackLoader::getId).collect(ImmutableSet.toImmutableSet());
    }

    public Collection<ResourcePackLoader> getSelectedPacks() {
        return this.selected;
    }

    @Nullable
    public ResourcePackLoader getPack(String var0) {
        return this.available.get(var0);
    }

    public boolean isAvailable(String var0) {
        return this.available.containsKey(var0);
    }

    public List<IResourcePack> openAllSelected() {
        return (List)this.selected.stream().map(ResourcePackLoader::open).collect(ImmutableList.toImmutableList());
    }
}

