/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.ResourcePackFolder;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.slf4j.Logger;

public class ResourcePackVanilla
implements IResourcePack {
    @Nullable
    public static Path generatedDir;
    private static final Logger LOGGER;
    public static Class<?> clientObject;
    private static final Map<EnumResourcePackType, Path> ROOT_DIR_BY_TYPE;
    public final ResourcePackInfo packMetadata;
    public final Set<String> namespaces;

    private static Path safeGetPath(URI var0) throws IOException {
        try {
            return Paths.get(var0);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable var1) {
            LOGGER.warn("Unable to get path for: {}", (Object)var0, (Object)var1);
        }
        try {
            FileSystems.newFileSystem(var0, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(var0);
    }

    public ResourcePackVanilla(ResourcePackInfo var0, String ... var1) {
        this.packMetadata = var0;
        this.namespaces = ImmutableSet.copyOf((Object[])var1);
    }

    @Override
    public InputStream getRootResource(String var0) throws IOException {
        Path var1;
        if (var0.contains("/") || var0.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if (generatedDir != null && Files.exists(var1 = generatedDir.resolve(var0), new LinkOption[0])) {
            return Files.newInputStream(var1, new OpenOption[0]);
        }
        return this.getResourceAsStream(var0);
    }

    @Override
    public InputStream getResource(EnumResourcePackType var0, MinecraftKey var1) throws IOException {
        InputStream var2 = this.getResourceAsStream(var0, var1);
        if (var2 != null) {
            return var2;
        }
        throw new FileNotFoundException(var1.getPath());
    }

    @Override
    public Collection<MinecraftKey> getResources(EnumResourcePackType var0, String var1, String var2, Predicate<MinecraftKey> var3) {
        Object var52;
        HashSet var4 = Sets.newHashSet();
        if (generatedDir != null) {
            try {
                ResourcePackVanilla.getResources(var4, var1, generatedDir.resolve(var0.getDirectory()), var2, var3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (var0 == EnumResourcePackType.CLIENT_RESOURCES) {
                var52 = null;
                try {
                    var52 = clientObject.getClassLoader().getResources(var0.getDirectory() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (var52 != null && var52.hasMoreElements()) {
                    try {
                        URI var6 = ((URL)var52.nextElement()).toURI();
                        if (!"file".equals(var6.getScheme())) continue;
                        ResourcePackVanilla.getResources(var4, var1, Paths.get(var6), var2, var3);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            var52 = ROOT_DIR_BY_TYPE.get((Object)var0);
            if (var52 != null) {
                ResourcePackVanilla.getResources(var4, var1, (Path)var52, var2, var3);
            } else {
                LOGGER.error("Can't access assets root for type: {}", (Object)var0);
            }
        }
        catch (FileNotFoundException | NoSuchFileException var52) {
        }
        catch (IOException var53) {
            LOGGER.error("Couldn't get a list of all vanilla resources", (Throwable)var53);
        }
        return var4;
    }

    private static void getResources(Collection<MinecraftKey> var02, String var1, Path var22, String var32, Predicate<MinecraftKey> var4) throws IOException {
        Path var5 = var22.resolve(var1);
        try (Stream<Path> var6 = Files.walk(var5.resolve(var32), new FileVisitOption[0]);){
            var6.filter(var0 -> !var0.endsWith(".mcmeta") && Files.isRegularFile(var0, new LinkOption[0])).mapMulti((var2, var3) -> {
                String var4 = var5.relativize((Path)var2).toString().replaceAll("\\\\", "/");
                MinecraftKey var5 = MinecraftKey.tryBuild(var1, var4);
                if (var5 == null) {
                    SystemUtils.logAndPauseIfInIde(String.format(Locale.ROOT, "Invalid path in datapack: %s:%s, ignoring", var1, var4));
                } else {
                    var3.accept(var5);
                }
            }).filter(var4).forEach(var02::add);
        }
    }

    @Nullable
    protected InputStream getResourceAsStream(EnumResourcePackType var0, MinecraftKey var1) {
        Object var3;
        String var2 = ResourcePackVanilla.createPath(var0, var1);
        if (generatedDir != null && Files.exists((Path)(var3 = generatedDir.resolve(var0.getDirectory() + "/" + var1.getNamespace() + "/" + var1.getPath())), new LinkOption[0])) {
            try {
                return Files.newInputStream((Path)var3, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            var3 = ResourcePackVanilla.class.getResource(var2);
            if (ResourcePackVanilla.isResourceUrlValid(var2, (URL)var3)) {
                return ((URL)var3).openStream();
            }
        }
        catch (IOException var32) {
            return ResourcePackVanilla.class.getResourceAsStream(var2);
        }
        return null;
    }

    private static String createPath(EnumResourcePackType var0, MinecraftKey var1) {
        return "/" + var0.getDirectory() + "/" + var1.getNamespace() + "/" + var1.getPath();
    }

    private static boolean isResourceUrlValid(String var0, @Nullable URL var1) throws IOException {
        return var1 != null && (var1.getProtocol().equals("jar") || ResourcePackFolder.validatePath(new File(var1.getFile()), var0));
    }

    @Nullable
    protected InputStream getResourceAsStream(String var0) {
        return ResourcePackVanilla.class.getResourceAsStream("/" + var0);
    }

    @Override
    public boolean hasResource(EnumResourcePackType var0, MinecraftKey var1) {
        Object var3;
        String var2 = ResourcePackVanilla.createPath(var0, var1);
        if (generatedDir != null && Files.exists((Path)(var3 = generatedDir.resolve(var0.getDirectory() + "/" + var1.getNamespace() + "/" + var1.getPath())), new LinkOption[0])) {
            return true;
        }
        try {
            var3 = ResourcePackVanilla.class.getResource(var2);
            return ResourcePackVanilla.isResourceUrlValid(var2, (URL)var3);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Set<String> getNamespaces(EnumResourcePackType var0) {
        return this.namespaces;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T getMetadataSection(ResourcePackMetaParser<T> var0) throws IOException {
        try (InputStream var1 = this.getRootResource("pack.mcmeta");){
            T var2;
            if (var1 != null && (var2 = ResourcePackAbstract.getMetadataFromStream(var0, var1)) != null) {
                T t2 = var2;
                return t2;
            }
        }
        catch (FileNotFoundException | RuntimeException exception) {
            // empty catch block
        }
        if (var0 != ResourcePackInfo.SERIALIZER) return null;
        return (T)this.packMetadata;
    }

    @Override
    public String getName() {
        return "Default";
    }

    @Override
    public void close() {
    }

    public ResourceProvider asProvider() {
        return var0 -> Optional.of(new IResource(this.getName(), () -> this.getResource(EnumResourcePackType.CLIENT_RESOURCES, var0)));
    }

    static {
        LOGGER = LogUtils.getLogger();
        ROOT_DIR_BY_TYPE = (Map)SystemUtils.make(() -> {
            Class<ResourcePackVanilla> clazz = ResourcePackVanilla.class;
            synchronized (ResourcePackVanilla.class) {
                ImmutableMap.Builder var1 = ImmutableMap.builder();
                for (EnumResourcePackType var5 : EnumResourcePackType.values()) {
                    String var6 = "/" + var5.getDirectory() + "/.mcassetsroot";
                    URL var7 = ResourcePackVanilla.class.getResource(var6);
                    if (var7 == null) {
                        LOGGER.error("File {} does not exist in classpath", (Object)var6);
                        continue;
                    }
                    try {
                        URI var8 = var7.toURI();
                        String var9 = var8.getScheme();
                        if (!"jar".equals(var9) && !"file".equals(var9)) {
                            LOGGER.warn("Assets URL '{}' uses unexpected schema", (Object)var8);
                        }
                        Path var10 = ResourcePackVanilla.safeGetPath(var8);
                        var1.put((Object)var5, (Object)var10.getParent());
                    }
                    catch (Exception var8) {
                        LOGGER.error("Couldn't resolve path to vanilla assets", (Throwable)var8);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return var1.build();
            }
        });
    }
}

