/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.ResourceNotFoundException;
import net.minecraft.server.packs.ResourcePackAbstract;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ResourcePackFile
extends ResourcePackAbstract {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Splitter SPLITTER = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    @Nullable
    private ZipFile zipFile;

    public ResourcePackFile(File var0) {
        super(var0);
    }

    private ZipFile getOrCreateZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
        return this.zipFile;
    }

    @Override
    protected InputStream getResource(String var0) throws IOException {
        ZipFile var1 = this.getOrCreateZipFile();
        ZipEntry var2 = var1.getEntry(var0);
        if (var2 == null) {
            throw new ResourceNotFoundException(this.file, var0);
        }
        return var1.getInputStream(var2);
    }

    @Override
    public boolean hasResource(String var0) {
        try {
            return this.getOrCreateZipFile().getEntry(var0) != null;
        }
        catch (IOException var1) {
            return false;
        }
    }

    @Override
    public Set<String> getNamespaces(EnumResourcePackType var0) {
        ZipFile var1;
        try {
            var1 = this.getOrCreateZipFile();
        }
        catch (IOException var2) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> var2 = var1.entries();
        HashSet var3 = Sets.newHashSet();
        while (var2.hasMoreElements()) {
            ArrayList var6;
            ZipEntry var4 = var2.nextElement();
            String var5 = var4.getName();
            if (!var5.startsWith(var0.getDirectory() + "/") || (var6 = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)var5))).size() <= 1) continue;
            String var7 = (String)var6.get(1);
            if (var7.equals(var7.toLowerCase(Locale.ROOT))) {
                var3.add(var7);
                continue;
            }
            this.logWarning(var7);
        }
        return var3;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.zipFile != null) {
            IOUtils.closeQuietly((Closeable)this.zipFile);
            this.zipFile = null;
        }
    }

    @Override
    public Collection<MinecraftKey> getResources(EnumResourcePackType var0, String var1, String var2, Predicate<MinecraftKey> var3) {
        ZipFile var4;
        try {
            var4 = this.getOrCreateZipFile();
        }
        catch (IOException var5) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> var5 = var4.entries();
        ArrayList var6 = Lists.newArrayList();
        String var7 = var0.getDirectory() + "/" + var1 + "/";
        String var8 = var7 + var2 + "/";
        while (var5.hasMoreElements()) {
            String var10;
            ZipEntry var9 = var5.nextElement();
            if (var9.isDirectory() || (var10 = var9.getName()).endsWith(".mcmeta") || !var10.startsWith(var8)) continue;
            String var11 = var10.substring(var7.length());
            MinecraftKey var12 = MinecraftKey.tryBuild(var1, var11);
            if (var12 == null) {
                LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)var1, (Object)var11);
                continue;
            }
            if (!var3.test(var12)) continue;
            var6.add(var12);
        }
        return var6;
    }
}

