/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.dedicated.ThreadWatchdog;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.storage.Convertable;
import org.slf4j.Logger;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int CONVERSION_RETRY_DELAY_MS = 5000;
    private static final int CONVERSION_RETRIES = 2;
    private final List<ServerCommand> consoleInput = Collections.synchronizedList(Lists.newArrayList());
    @Nullable
    private RemoteStatusListener queryThreadGs4;
    public final RemoteControlCommandListener rconConsoleSource;
    @Nullable
    private RemoteControlListener rconThread;
    public DedicatedServerSettings settings;
    @Nullable
    private ServerGUI gui;
    @Nullable
    private final TextFilter textFilterClient;

    public DedicatedServer(Thread var0, Convertable.ConversionSession var1, ResourcePackRepository var2, WorldStem var3, DedicatedServerSettings var4, DataFixer var5, Services var6, WorldLoadListenerFactory var7) {
        super(var0, var1, var2, var3, Proxy.NO_PROXY, var5, var6, var7);
        this.settings = var4;
        this.rconConsoleSource = new RemoteControlCommandListener(this);
        this.textFilterClient = TextFilter.createFromConfig(var4.getProperties().textFilteringConfig);
    }

    @Override
    public boolean initServer() throws IOException {
        Thread var0 = new Thread("Server console handler"){

            @Override
            public void run() {
                BufferedReader var0 = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    String var1;
                    while (!DedicatedServer.this.isStopped() && DedicatedServer.this.isRunning() && (var1 = var0.readLine()) != null) {
                        DedicatedServer.this.handleConsoleInput(var1, DedicatedServer.this.createCommandSourceStack());
                    }
                }
                catch (IOException var2) {
                    LOGGER.error("Exception handling console input", (Throwable)var2);
                }
            }
        };
        var0.setDaemon(true);
        var0.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        var0.start();
        LOGGER.info("Starting minecraft server version {}", (Object)SharedConstants.getCurrentVersion().getName());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            LOGGER.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        LOGGER.info("Loading properties");
        DedicatedServerProperties var1 = this.settings.getProperties();
        if (this.isSingleplayer()) {
            this.setLocalIp("127.0.0.1");
        } else {
            this.setUsesAuthentication(var1.onlineMode);
            this.setPreventProxyConnections(var1.preventProxyConnections);
            this.setLocalIp(var1.serverIp);
        }
        this.setPvpAllowed(var1.pvp);
        this.setFlightAllowed(var1.allowFlight);
        this.setMotd(var1.motd);
        super.setPlayerIdleTimeout(var1.playerIdleTimeout.get());
        this.setEnforceWhitelist(var1.enforceWhitelist);
        this.worldData.setGameType(var1.gamemode);
        LOGGER.info("Default game type: {}", (Object)var1.gamemode);
        InetAddress var2 = null;
        if (!this.getLocalIp().isEmpty()) {
            var2 = InetAddress.getByName(this.getLocalIp());
        }
        if (this.getPort() < 0) {
            this.setPort(var1.serverPort);
        }
        this.initializeKeyPair();
        LOGGER.info("Starting Minecraft server on {}:{}", (Object)(this.getLocalIp().isEmpty() ? "*" : this.getLocalIp()), (Object)this.getPort());
        try {
            this.getConnection().startTcpServerListener(var2, this.getPort());
        }
        catch (IOException var3) {
            LOGGER.warn("**** FAILED TO BIND TO PORT!");
            LOGGER.warn("The exception was: {}", (Object)var3.toString());
            LOGGER.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.usesAuthentication()) {
            LOGGER.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            LOGGER.warn("The server will make no attempt to authenticate usernames. Beware.");
            LOGGER.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            LOGGER.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.convertOldUsers()) {
            this.getProfileCache().save();
        }
        if (!NameReferencingFileConverter.serverReadyAfterUserconversion(this)) {
            return false;
        }
        this.setPlayerList(new DedicatedPlayerList(this, this.registryAccess(), this.playerDataStorage));
        long var3 = SystemUtils.getNanos();
        TileEntitySkull.setup(this.services, this);
        UserCache.setUsesAuthentication(this.usesAuthentication());
        LOGGER.info("Preparing level \"{}\"", (Object)this.getLevelIdName());
        this.loadLevel();
        long var5 = SystemUtils.getNanos() - var3;
        String var7 = String.format(Locale.ROOT, "%.3fs", (double)var5 / 1.0E9);
        LOGGER.info("Done ({})! For help, type \"help\"", (Object)var7);
        if (var1.announcePlayerAchievements != null) {
            this.getGameRules().getRule(GameRules.RULE_ANNOUNCE_ADVANCEMENTS).set(var1.announcePlayerAchievements, this);
        }
        if (var1.enableQuery) {
            LOGGER.info("Starting GS4 status listener");
            this.queryThreadGs4 = RemoteStatusListener.create(this);
        }
        if (var1.enableRcon) {
            LOGGER.info("Starting remote control listener");
            this.rconThread = RemoteControlListener.create(this);
        }
        if (this.getMaxTickLength() > 0L) {
            Thread var8 = new Thread(new ThreadWatchdog(this));
            var8.setUncaughtExceptionHandler(new ThreadNamedUncaughtExceptionHandler(LOGGER));
            var8.setName("Server Watchdog");
            var8.setDaemon(true);
            var8.start();
        }
        Items.AIR.fillItemCategory(CreativeModeTab.TAB_SEARCH, NonNullList.create());
        if (var1.enableJmxMonitoring) {
            MinecraftServerBeans.registerJmxMonitoring(this);
            LOGGER.info("JMX monitoring enabled");
        }
        return true;
    }

    @Override
    public boolean isSpawningAnimals() {
        return this.getProperties().spawnAnimals && super.isSpawningAnimals();
    }

    @Override
    public boolean isSpawningMonsters() {
        return this.settings.getProperties().spawnMonsters && super.isSpawningMonsters();
    }

    @Override
    public boolean areNpcsEnabled() {
        return this.settings.getProperties().spawnNpcs && super.areNpcsEnabled();
    }

    @Override
    public DedicatedServerProperties getProperties() {
        return this.settings.getProperties();
    }

    @Override
    public void forceDifficulty() {
        this.setDifficulty(this.getProperties().difficulty, true);
    }

    @Override
    public boolean isHardcore() {
        return this.getProperties().hardcore;
    }

    @Override
    public SystemReport fillServerSystemReport(SystemReport var0) {
        var0.setDetail("Is Modded", () -> this.getModdedStatus().fullDescription());
        var0.setDetail("Type", () -> "Dedicated Server (map_server.txt)");
        return var0;
    }

    @Override
    public void dumpServerProperties(Path var0) throws IOException {
        DedicatedServerProperties var1 = this.getProperties();
        try (BufferedWriter var2 = Files.newBufferedWriter(var0, new OpenOption[0]);){
            var2.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", var1.syncChunkWrites));
            var2.write(String.format(Locale.ROOT, "gamemode=%s%n", new Object[]{var1.gamemode}));
            var2.write(String.format(Locale.ROOT, "spawn-monsters=%s%n", var1.spawnMonsters));
            var2.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", var1.entityBroadcastRangePercentage));
            var2.write(String.format(Locale.ROOT, "max-world-size=%d%n", var1.maxWorldSize));
            var2.write(String.format(Locale.ROOT, "spawn-npcs=%s%n", var1.spawnNpcs));
            var2.write(String.format(Locale.ROOT, "view-distance=%d%n", var1.viewDistance));
            var2.write(String.format(Locale.ROOT, "simulation-distance=%d%n", var1.simulationDistance));
            var2.write(String.format(Locale.ROOT, "spawn-animals=%s%n", var1.spawnAnimals));
            var2.write(String.format(Locale.ROOT, "generate-structures=%s%n", var1.getWorldGenSettings(this.registryAccess()).generateStructures()));
            var2.write(String.format(Locale.ROOT, "use-native=%s%n", var1.useNativeTransport));
            var2.write(String.format(Locale.ROOT, "rate-limit=%d%n", var1.rateLimitPacketsPerSecond));
        }
    }

    @Override
    public void onServerExit() {
        if (this.textFilterClient != null) {
            this.textFilterClient.close();
        }
        if (this.gui != null) {
            this.gui.close();
        }
        if (this.rconThread != null) {
            this.rconThread.stop();
        }
        if (this.queryThreadGs4 != null) {
            this.queryThreadGs4.stop();
        }
    }

    @Override
    public void tickChildren(BooleanSupplier var0) {
        super.tickChildren(var0);
        this.handleConsoleInputs();
    }

    @Override
    public boolean isNetherEnabled() {
        return this.getProperties().allowNether;
    }

    public void handleConsoleInput(String var0, CommandListenerWrapper var1) {
        this.consoleInput.add(new ServerCommand(var0, var1));
    }

    public void handleConsoleInputs() {
        while (!this.consoleInput.isEmpty()) {
            ServerCommand var0 = this.consoleInput.remove(0);
            this.getCommands().performPrefixedCommand(var0.source, var0.msg);
        }
    }

    @Override
    public boolean isDedicatedServer() {
        return true;
    }

    @Override
    public int getRateLimitPacketsPerSecond() {
        return this.getProperties().rateLimitPacketsPerSecond;
    }

    @Override
    public boolean isEpollEnabled() {
        return this.getProperties().useNativeTransport;
    }

    @Override
    public boolean previewsChat() {
        return this.getProperties().previewsChat;
    }

    @Override
    public DedicatedPlayerList getPlayerList() {
        return (DedicatedPlayerList)super.getPlayerList();
    }

    @Override
    public boolean isPublished() {
        return true;
    }

    @Override
    public String getServerIp() {
        return this.getLocalIp();
    }

    @Override
    public int getServerPort() {
        return this.getPort();
    }

    @Override
    public String getServerName() {
        return this.getMotd();
    }

    public void showGui() {
        if (this.gui == null) {
            this.gui = ServerGUI.showFrameFor(this);
        }
    }

    @Override
    public boolean hasGui() {
        return this.gui != null;
    }

    @Override
    public boolean isCommandBlockEnabled() {
        return this.getProperties().enableCommandBlock;
    }

    @Override
    public int getSpawnProtectionRadius() {
        return this.getProperties().spawnProtection;
    }

    @Override
    public boolean isUnderSpawnProtection(WorldServer var0, BlockPosition var1, EntityHuman var2) {
        int var5;
        if (var0.dimension() != World.OVERWORLD) {
            return false;
        }
        if (this.getPlayerList().getOps().isEmpty()) {
            return false;
        }
        if (this.getPlayerList().isOp(var2.getGameProfile())) {
            return false;
        }
        if (this.getSpawnProtectionRadius() <= 0) {
            return false;
        }
        BlockPosition var3 = var0.getSharedSpawnPos();
        int var4 = MathHelper.abs(var1.getX() - var3.getX());
        int var6 = Math.max(var4, var5 = MathHelper.abs(var1.getZ() - var3.getZ()));
        return var6 <= this.getSpawnProtectionRadius();
    }

    @Override
    public boolean repliesToStatus() {
        return this.getProperties().enableStatus;
    }

    @Override
    public boolean hidesOnlinePlayers() {
        return this.getProperties().hideOnlinePlayers;
    }

    @Override
    public int getOperatorUserPermissionLevel() {
        return this.getProperties().opPermissionLevel;
    }

    @Override
    public int getFunctionCompilationLevel() {
        return this.getProperties().functionPermissionLevel;
    }

    @Override
    public void setPlayerIdleTimeout(int var0) {
        super.setPlayerIdleTimeout(var0);
        this.settings.update(var1 -> (DedicatedServerProperties)var1.playerIdleTimeout.update(this.registryAccess(), var0));
    }

    @Override
    public boolean shouldRconBroadcast() {
        return this.getProperties().broadcastRconToOps;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.getProperties().broadcastConsoleToOps;
    }

    @Override
    public int getAbsoluteMaxWorldSize() {
        return this.getProperties().maxWorldSize;
    }

    @Override
    public int getCompressionThreshold() {
        return this.getProperties().networkCompressionThreshold;
    }

    @Override
    public boolean enforceSecureProfile() {
        return this.getProperties().enforceSecureProfile && this.getProperties().onlineMode;
    }

    protected boolean convertOldUsers() {
        int var0;
        boolean var1 = false;
        for (var0 = 0; !var1 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.waitForRetry();
            }
            var1 = NameReferencingFileConverter.convertUserBanlist(this);
        }
        boolean var2 = false;
        for (var0 = 0; !var2 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.waitForRetry();
            }
            var2 = NameReferencingFileConverter.convertIpBanlist(this);
        }
        boolean var3 = false;
        for (var0 = 0; !var3 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.waitForRetry();
            }
            var3 = NameReferencingFileConverter.convertOpsList(this);
        }
        boolean var4 = false;
        for (var0 = 0; !var4 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.waitForRetry();
            }
            var4 = NameReferencingFileConverter.convertWhiteList(this);
        }
        boolean var5 = false;
        for (var0 = 0; !var5 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.waitForRetry();
            }
            var5 = NameReferencingFileConverter.convertPlayers(this);
        }
        return var1 || var2 || var3 || var4 || var5;
    }

    private void waitForRetry() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException var0) {
            return;
        }
    }

    public long getMaxTickLength() {
        return this.getProperties().maxTickTime;
    }

    @Override
    public int getMaxChainedNeighborUpdates() {
        return this.getProperties().maxChainedNeighborUpdates;
    }

    @Override
    public String getPluginNames() {
        return "";
    }

    @Override
    public String runCommand(String var0) {
        this.rconConsoleSource.prepareForCommand();
        this.executeBlocking(() -> this.getCommands().performPrefixedCommand(this.rconConsoleSource.createCommandSourceStack(), var0));
        return this.rconConsoleSource.getCommandResponse();
    }

    public void storeUsingWhiteList(boolean var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.whiteList.update(this.registryAccess(), var0));
    }

    @Override
    public void stopServer() {
        super.stopServer();
        SystemUtils.shutdownExecutors();
        TileEntitySkull.clear();
    }

    @Override
    public boolean isSingleplayerOwner(GameProfile var0) {
        return false;
    }

    @Override
    public int getScaledTrackingDistance(int var0) {
        return this.getProperties().entityBroadcastRangePercentage * var0 / 100;
    }

    @Override
    public String getLevelIdName() {
        return this.storageSource.getLevelId();
    }

    @Override
    public boolean forceSynchronousWrites() {
        return this.settings.getProperties().syncChunkWrites;
    }

    @Override
    public ITextFilter createTextFilterForPlayer(EntityPlayer var0) {
        if (this.textFilterClient != null) {
            return this.textFilterClient.createContext(var0.getGameProfile());
        }
        return ITextFilter.DUMMY;
    }

    @Override
    @Nullable
    public EnumGamemode getForcedGameType() {
        return this.settings.getProperties().forceGameMode ? this.worldData.getGameType() : null;
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> getServerResourcePack() {
        return this.settings.getProperties().serverResourcePackInfo;
    }

    @Override
    public /* synthetic */ PlayerList getPlayerList() {
        return this.getPlayerList();
    }
}

