/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;

public class CommandDataAccessorEntity
implements CommandDataAccessor {
    private static final SimpleCommandExceptionType ERROR_NO_PLAYERS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.data.entity.invalid"));
    public static final Function<String, CommandData.c> PROVIDER = var0 -> new CommandData.c((String)var0){
        final /* synthetic */ String a;
        {
            this.a = string;
        }

        @Override
        public CommandDataAccessor access(CommandContext<CommandListenerWrapper> var0) throws CommandSyntaxException {
            return new CommandDataAccessorEntity(ArgumentEntity.getEntity(var0, this.a));
        }

        @Override
        public ArgumentBuilder<CommandListenerWrapper, ?> wrap(ArgumentBuilder<CommandListenerWrapper, ?> var0, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var1) {
            return var0.then(CommandDispatcher.literal("entity").then(var1.apply((ArgumentBuilder<CommandListenerWrapper, ?>)CommandDispatcher.argument(this.a, ArgumentEntity.entity()))));
        }
    };
    private final Entity entity;

    public CommandDataAccessorEntity(Entity var0) {
        this.entity = var0;
    }

    @Override
    public void setData(NBTTagCompound var0) throws CommandSyntaxException {
        if (this.entity instanceof EntityHuman) {
            throw ERROR_NO_PLAYERS.create();
        }
        UUID var1 = this.entity.getUUID();
        this.entity.load(var0);
        this.entity.setUUID(var1);
    }

    @Override
    public NBTTagCompound getData() {
        return CriterionConditionNBT.getEntityTagToCompare(this.entity);
    }

    @Override
    public IChatBaseComponent getModifiedSuccess() {
        return IChatBaseComponent.translatable("commands.data.entity.modified", this.entity.getDisplayName());
    }

    @Override
    public IChatBaseComponent getPrintSuccess(NBTBase var0) {
        return IChatBaseComponent.translatable("commands.data.entity.query", this.entity.getDisplayName(), GameProfileSerializer.toPrettyComponent(var0));
    }

    @Override
    public IChatBaseComponent getPrintSuccess(ArgumentNBTKey.g var0, double var1, int var3) {
        return IChatBaseComponent.translatable("commands.data.entity.get", var0, this.entity.getDisplayName(), String.format(Locale.ROOT, "%.2f", var1), var3);
    }
}

