/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingPlayerChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreboardTeam;

public class CommandTeamMsg {
    private static final ChatModifier SUGGEST_STYLE = ChatModifier.EMPTY.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.translatable("chat.type.team.hover"))).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, "/teammsg "));
    private static final SimpleCommandExceptionType ERROR_NOT_ON_TEAM = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.teammsg.failed.noteam"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralCommandNode var1 = var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("teammsg").then(net.minecraft.commands.CommandDispatcher.argument("message", ArgumentChat.message()).executes(var0 -> {
            ArgumentChat.a var1 = ArgumentChat.getChatMessage((CommandContext<CommandListenerWrapper>)var0, "message");
            try {
                return CommandTeamMsg.sendMessage((CommandListenerWrapper)var0.getSource(), var1);
            }
            catch (Exception var2) {
                var1.consume((CommandListenerWrapper)var0.getSource());
                throw var2;
            }
        })));
        var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("tm").redirect((CommandNode)var1));
    }

    private static int sendMessage(CommandListenerWrapper var0, ArgumentChat.a var1) throws CommandSyntaxException {
        Entity var22 = var0.getEntityOrException();
        ScoreboardTeam var3 = (ScoreboardTeam)var22.getTeam();
        if (var3 == null) {
            throw ERROR_NOT_ON_TEAM.create();
        }
        IChatMutableComponent var4 = var3.getFormattedDisplayName().withStyle(SUGGEST_STYLE);
        ChatMessageType.a var52 = ChatMessageType.bind(ChatMessageType.TEAM_MSG_COMMAND_INCOMING, var0).withTargetName(var4);
        ChatMessageType.a var6 = ChatMessageType.bind(ChatMessageType.TEAM_MSG_COMMAND_OUTGOING, var0).withTargetName(var4);
        List<EntityPlayer> var7 = var0.getServer().getPlayerList().getPlayers().stream().filter(var2 -> var2 == var22 || var2.getTeam() == var3).toList();
        var1.resolve(var0, var5 -> {
            OutgoingPlayerChatMessage var6 = OutgoingPlayerChatMessage.create(var5);
            boolean var7 = var5.isFullyFiltered();
            boolean var8 = false;
            for (EntityPlayer var10 : var7) {
                ChatMessageType.a var11 = var10 == var22 ? var6 : var52;
                boolean var12 = var0.shouldFilterMessageTo(var10);
                var10.sendChatMessage(var6, var12, var11);
                var8 |= var7 && var12 && var10 != var22;
            }
            if (var8) {
                var0.sendSystemMessage(PlayerList.CHAT_FILTERED_FULL);
            }
            var6.sendHeadersToRemainingPlayers(var0.getServer().getPlayerList());
        });
        return var7.size();
    }
}

