/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;

public class CommandExecute {
    private static final int MAX_TEST_AREA = 32768;
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("commands.execute.blocks.toobig", var0, var1));
    private static final SimpleCommandExceptionType ERROR_CONDITIONAL_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType ERROR_CONDITIONAL_FAILED_COUNT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.execute.conditional.fail_count", var0));
    private static final BinaryOperator<ResultConsumer<CommandListenerWrapper>> CALLBACK_CHAINER = (var0, var1) -> (var2, var3, var4) -> {
        var0.onCommandComplete(var2, var3, var4);
        var1.onCommandComplete(var2, var3, var4);
    };
    private static final SuggestionProvider<CommandListenerWrapper> SUGGEST_PREDICATE = (var0, var1) -> {
        LootPredicateManager var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getPredicateManager();
        return ICompletionProvider.suggestResource(var2.getKeys(), var1);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        LiteralCommandNode var2 = var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("execute").requires(var0 -> var0.hasPermission(2)));
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("execute").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("run").redirect((CommandNode)var02.getRoot()))).then(CommandExecute.addConditionals((CommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("if"), true, var1))).then(CommandExecute.addConditionals((CommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("unless"), false, var1))).then(net.minecraft.commands.CommandDispatcher.literal("as").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).withEntity(entity));
            }
            return var1;
        })))).then(net.minecraft.commands.CommandDispatcher.literal("at").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).withLevel((WorldServer)entity.level).withPosition(entity.position()).withRotation(entity.getRotationVector()));
            }
            return var1;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("store").then(CommandExecute.wrapStores((LiteralCommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("result"), true))).then(CommandExecute.wrapStores((LiteralCommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("success"), false)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("positioned").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec3.vec3()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withPosition(ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos")).withAnchor(ArgumentAnchor.Anchor.FEET)))).then(net.minecraft.commands.CommandDispatcher.literal("as").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).withPosition(entity.position()));
            }
            return var1;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("rotated").then(net.minecraft.commands.CommandDispatcher.argument("rot", ArgumentRotation.rotation()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withRotation(ArgumentRotation.getRotation((CommandContext<CommandListenerWrapper>)var0, "rot").getRotation((CommandListenerWrapper)var0.getSource()))))).then(net.minecraft.commands.CommandDispatcher.literal("as").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).withRotation(entity.getRotationVector()));
            }
            return var1;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("facing").then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(net.minecraft.commands.CommandDispatcher.argument("anchor", ArgumentAnchor.anchor()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            ArgumentAnchor.Anchor var2 = ArgumentAnchor.getAnchor((CommandContext<CommandListenerWrapper>)var0, "anchor");
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).facing(entity, var2));
            }
            return var1;
        }))))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec3.vec3()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).facing(ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos")))))).then(net.minecraft.commands.CommandDispatcher.literal("align").then(net.minecraft.commands.CommandDispatcher.argument("axes", ArgumentRotationAxis.swizzle()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withPosition(((CommandListenerWrapper)var0.getSource()).getPosition().align(ArgumentRotationAxis.getSwizzle((CommandContext<CommandListenerWrapper>)var0, "axes"))))))).then(net.minecraft.commands.CommandDispatcher.literal("anchored").then(net.minecraft.commands.CommandDispatcher.argument("anchor", ArgumentAnchor.anchor()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withAnchor(ArgumentAnchor.getAnchor((CommandContext<CommandListenerWrapper>)var0, "anchor")))))).then(net.minecraft.commands.CommandDispatcher.literal("in").then(net.minecraft.commands.CommandDispatcher.argument("dimension", ArgumentDimension.dimension()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withLevel(ArgumentDimension.getDimension((CommandContext<CommandListenerWrapper>)var0, "dimension"))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> wrapStores(LiteralCommandNode<CommandListenerWrapper> var0, LiteralArgumentBuilder<CommandListenerWrapper> var12, boolean var2) {
        var12.then(net.minecraft.commands.CommandDispatcher.literal("score").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).redirect(var0, var1 -> CommandExecute.storeValue((CommandListenerWrapper)var1.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var1, "objective"), var2)))));
        var12.then(net.minecraft.commands.CommandDispatcher.literal("bossbar").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(CommandBossBar.SUGGEST_BOSS_BAR).then(net.minecraft.commands.CommandDispatcher.literal("value").redirect(var0, var1 -> CommandExecute.storeValue((CommandListenerWrapper)var1.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var1), true, var2)))).then(net.minecraft.commands.CommandDispatcher.literal("max").redirect(var0, var1 -> CommandExecute.storeValue((CommandListenerWrapper)var1.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var1), false, var2)))));
        for (CommandData.c var4 : CommandData.TARGET_PROVIDERS) {
            var4.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)var12, var3 -> var3.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("path", ArgumentNBTKey.nbtPath()).then(net.minecraft.commands.CommandDispatcher.literal("int").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagInt.valueOf((int)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("float").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagFloat.valueOf((float)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("short").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagShort.valueOf((short)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("long").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagLong.valueOf((long)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("double").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagDouble.valueOf((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale")), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("byte").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagByte.valueOf((byte)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))));
        }
        return var12;
    }

    private static CommandListenerWrapper storeValue(CommandListenerWrapper var0, Collection<String> var1, ScoreboardObjective var2, boolean var3) {
        ScoreboardServer var42 = var0.getServer().getScoreboard();
        return var0.withCallback((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(var4, var5, var6) -> {
            for (String var8 : var1) {
                ScoreboardScore var9 = var42.getOrCreatePlayerScore(var8, var2);
                int var10 = var3 ? var6 : (var5 ? 1 : 0);
                var9.setScore(var10);
            }
        }), CALLBACK_CHAINER);
    }

    private static CommandListenerWrapper storeValue(CommandListenerWrapper var0, BossBattleCustom var1, boolean var2, boolean var32) {
        return var0.withCallback((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(var3, var4, var5) -> {
            int var6;
            int n2 = var32 ? var5 : (var6 = var4 ? 1 : 0);
            if (var2) {
                var1.setValue(var6);
            } else {
                var1.setMax(var6);
            }
        }), CALLBACK_CHAINER);
    }

    private static CommandListenerWrapper storeData(CommandListenerWrapper var0, CommandDataAccessor var1, ArgumentNBTKey.g var2, IntFunction<NBTBase> var3, boolean var42) {
        return var0.withCallback((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(var4, var5, var6) -> {
            try {
                NBTTagCompound var7 = var1.getData();
                int var8 = var42 ? var6 : (var5 ? 1 : 0);
                var2.set((NBTBase)var7, () -> (NBTBase)var3.apply(var8));
                var1.setData(var7);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }), CALLBACK_CHAINER);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> addConditionals(CommandNode<CommandListenerWrapper> var03, LiteralArgumentBuilder<CommandListenerWrapper> var12, boolean var2, CommandBuildContext var32) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var12.then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("block", ArgumentBlockPredicate.blockPredicate(var32)), var2, var0 -> ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "block").test(new ShapeDetectorBlock(((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), true))))))).then(net.minecraft.commands.CommandDispatcher.literal("score").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targetObjective", ArgumentScoreboardObjective.objective()).then(net.minecraft.commands.CommandDispatcher.literal("=").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var0 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var0, Integer::equals)))))).then(net.minecraft.commands.CommandDispatcher.literal("<").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (Integer var0, Integer var1) -> var0 < var1)))))).then(net.minecraft.commands.CommandDispatcher.literal("<=").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (Integer var0, Integer var1) -> var0 <= var1)))))).then(net.minecraft.commands.CommandDispatcher.literal(">").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (Integer var0, Integer var1) -> var0 > var1)))))).then(net.minecraft.commands.CommandDispatcher.literal(">=").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (Integer var0, Integer var1) -> var0 >= var1)))))).then(net.minecraft.commands.CommandDispatcher.literal("matches").then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("range", ArgumentCriterionValue.intRange()), var2, var0 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var0, ArgumentCriterionValue.b.getRange((CommandContext<CommandListenerWrapper>)var0, "range"))))))))).then(net.minecraft.commands.CommandDispatcher.literal("blocks").then(net.minecraft.commands.CommandDispatcher.argument("start", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("end", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentPosition.blockPos()).then(CommandExecute.addIfBlocksConditional(var03, net.minecraft.commands.CommandDispatcher.literal("all"), var2, false))).then(CommandExecute.addIfBlocksConditional(var03, net.minecraft.commands.CommandDispatcher.literal("masked"), var2, true))))))).then(net.minecraft.commands.CommandDispatcher.literal("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("entities", ArgumentEntity.entities()).fork(var03, var1 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var1, var2, !ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var1, "entities").isEmpty()))).executes(CommandExecute.createNumericConditionalHandler(var2, var0 -> ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "entities").size()))))).then(net.minecraft.commands.CommandDispatcher.literal("predicate").then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("predicate", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_PREDICATE), var2, var0 -> CommandExecute.checkCustomPredicate((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getPredicate((CommandContext<CommandListenerWrapper>)var0, "predicate")))));
        for (CommandData.c var5 : CommandData.SOURCE_PROVIDERS) {
            var12.then(var5.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.literal("data"), var3 -> var3.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("path", ArgumentNBTKey.nbtPath()).fork(var03, var2 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var2, var2, CommandExecute.checkMatchingData(var5.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path")) > 0))).executes(CommandExecute.createNumericConditionalHandler(var2, var1 -> CommandExecute.checkMatchingData(var5.access((CommandContext<CommandListenerWrapper>)var1), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var1, "path")))))));
        }
        return var12;
    }

    private static Command<CommandListenerWrapper> createNumericConditionalHandler(boolean var0, a var12) {
        if (var0) {
            return var1 -> {
                int var2 = var12.test((CommandContext<CommandListenerWrapper>)var1);
                if (var2 > 0) {
                    ((CommandListenerWrapper)var1.getSource()).sendSuccess(IChatBaseComponent.translatable("commands.execute.conditional.pass_count", var2), false);
                    return var2;
                }
                throw ERROR_CONDITIONAL_FAILED.create();
            };
        }
        return var1 -> {
            int var2 = var12.test((CommandContext<CommandListenerWrapper>)var1);
            if (var2 == 0) {
                ((CommandListenerWrapper)var1.getSource()).sendSuccess(IChatBaseComponent.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)var2);
        };
    }

    private static int checkMatchingData(CommandDataAccessor var0, ArgumentNBTKey.g var1) throws CommandSyntaxException {
        return var1.countMatching(var0.getData());
    }

    private static boolean checkScore(CommandContext<CommandListenerWrapper> var0, BiPredicate<Integer, Integer> var1) throws CommandSyntaxException {
        String var2 = ArgumentScoreholder.getName(var0, "target");
        ScoreboardObjective var3 = ArgumentScoreboardObjective.getObjective(var0, "targetObjective");
        String var4 = ArgumentScoreholder.getName(var0, "source");
        ScoreboardObjective var5 = ArgumentScoreboardObjective.getObjective(var0, "sourceObjective");
        ScoreboardServer var6 = ((CommandListenerWrapper)var0.getSource()).getServer().getScoreboard();
        if (!var6.hasPlayerScore(var2, var3) || !var6.hasPlayerScore(var4, var5)) {
            return false;
        }
        ScoreboardScore var7 = var6.getOrCreatePlayerScore(var2, var3);
        ScoreboardScore var8 = var6.getOrCreatePlayerScore(var4, var5);
        return var1.test(var7.getScore(), var8.getScore());
    }

    private static boolean checkScore(CommandContext<CommandListenerWrapper> var0, CriterionConditionValue.IntegerRange var1) throws CommandSyntaxException {
        String var2 = ArgumentScoreholder.getName(var0, "target");
        ScoreboardObjective var3 = ArgumentScoreboardObjective.getObjective(var0, "targetObjective");
        ScoreboardServer var4 = ((CommandListenerWrapper)var0.getSource()).getServer().getScoreboard();
        if (!var4.hasPlayerScore(var2, var3)) {
            return false;
        }
        return var1.matches(var4.getOrCreatePlayerScore(var2, var3).getScore());
    }

    private static boolean checkCustomPredicate(CommandListenerWrapper var0, LootItemCondition var1) {
        WorldServer var2 = var0.getLevel();
        LootTableInfo.Builder var3 = new LootTableInfo.Builder(var2).withParameter(LootContextParameters.ORIGIN, var0.getPosition()).withOptionalParameter(LootContextParameters.THIS_ENTITY, var0.getEntity());
        return var1.test(var3.create(LootContextParameterSets.COMMAND));
    }

    private static Collection<CommandListenerWrapper> expect(CommandContext<CommandListenerWrapper> var0, boolean var1, boolean var2) {
        if (var2 == var1) {
            return Collections.singleton((CommandListenerWrapper)var0.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> addConditional(CommandNode<CommandListenerWrapper> var0, ArgumentBuilder<CommandListenerWrapper, ?> var1, boolean var22, b var3) {
        return var1.fork(var0, var2 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var2, var22, var3.test((CommandContext<CommandListenerWrapper>)var2))).executes(var2 -> {
            if (var22 == var3.test((CommandContext<CommandListenerWrapper>)var2)) {
                ((CommandListenerWrapper)var2.getSource()).sendSuccess(IChatBaseComponent.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED.create();
        });
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> addIfBlocksConditional(CommandNode<CommandListenerWrapper> var0, ArgumentBuilder<CommandListenerWrapper, ?> var12, boolean var22, boolean var3) {
        return var12.fork(var0, var2 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var2, var22, CommandExecute.checkRegions((CommandContext<CommandListenerWrapper>)var2, var3).isPresent())).executes(var22 ? var1 -> CommandExecute.checkIfRegions((CommandContext<CommandListenerWrapper>)var1, var3) : var1 -> CommandExecute.checkUnlessRegions((CommandContext<CommandListenerWrapper>)var1, var3));
    }

    private static int checkIfRegions(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        OptionalInt var2 = CommandExecute.checkRegions(var0, var1);
        if (var2.isPresent()) {
            ((CommandListenerWrapper)var0.getSource()).sendSuccess(IChatBaseComponent.translatable("commands.execute.conditional.pass_count", var2.getAsInt()), false);
            return var2.getAsInt();
        }
        throw ERROR_CONDITIONAL_FAILED.create();
    }

    private static int checkUnlessRegions(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        OptionalInt var2 = CommandExecute.checkRegions(var0, var1);
        if (var2.isPresent()) {
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)var2.getAsInt());
        }
        ((CommandListenerWrapper)var0.getSource()).sendSuccess(IChatBaseComponent.translatable("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt checkRegions(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        return CommandExecute.checkRegions(((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentPosition.getLoadedBlockPos(var0, "start"), ArgumentPosition.getLoadedBlockPos(var0, "end"), ArgumentPosition.getLoadedBlockPos(var0, "destination"), var1);
    }

    private static OptionalInt checkRegions(WorldServer var0, BlockPosition var1, BlockPosition var2, BlockPosition var3, boolean var4) throws CommandSyntaxException {
        StructureBoundingBox var5 = StructureBoundingBox.fromCorners(var1, var2);
        StructureBoundingBox var6 = StructureBoundingBox.fromCorners(var3, var3.offset(var5.getLength()));
        BlockPosition var7 = new BlockPosition(var6.minX() - var5.minX(), var6.minY() - var5.minY(), var6.minZ() - var5.minZ());
        int var8 = var5.getXSpan() * var5.getYSpan() * var5.getZSpan();
        if (var8 > 32768) {
            throw ERROR_AREA_TOO_LARGE.create((Object)32768, (Object)var8);
        }
        int var9 = 0;
        for (int var10 = var5.minZ(); var10 <= var5.maxZ(); ++var10) {
            for (int var11 = var5.minY(); var11 <= var5.maxY(); ++var11) {
                for (int var12 = var5.minX(); var12 <= var5.maxX(); ++var12) {
                    BlockPosition var13 = new BlockPosition(var12, var11, var10);
                    BlockPosition var14 = var13.offset(var7);
                    IBlockData var15 = var0.getBlockState(var13);
                    if (var4 && var15.is(Blocks.AIR)) continue;
                    if (var15 != var0.getBlockState(var14)) {
                        return OptionalInt.empty();
                    }
                    TileEntity var16 = var0.getBlockEntity(var13);
                    TileEntity var17 = var0.getBlockEntity(var14);
                    if (var16 != null) {
                        NBTTagCompound var19;
                        if (var17 == null) {
                            return OptionalInt.empty();
                        }
                        if (var17.getType() != var16.getType()) {
                            return OptionalInt.empty();
                        }
                        NBTTagCompound var18 = var16.saveWithoutMetadata();
                        if (!var18.equals(var19 = var17.saveWithoutMetadata())) {
                            return OptionalInt.empty();
                        }
                    }
                    ++var9;
                }
            }
        }
        return OptionalInt.of(var9);
    }

    @FunctionalInterface
    static interface b {
        public boolean test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public int test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }
}

