/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;

public class CommandBanIp {
    public static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final SimpleCommandExceptionType ERROR_INVALID_IP = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.banip.invalid"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.banip.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("ban-ip").requires(var0 -> var0.hasPermission(3))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("target", StringArgumentType.word()).executes(var0 -> CommandBanIp.banIpOrName((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"target"), null))).then(net.minecraft.commands.CommandDispatcher.argument("reason", ArgumentChat.message()).executes(var0 -> CommandBanIp.banIpOrName((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"target"), ArgumentChat.getMessage((CommandContext<CommandListenerWrapper>)var0, "reason"))))));
    }

    private static int banIpOrName(CommandListenerWrapper var0, String var1, @Nullable IChatBaseComponent var2) throws CommandSyntaxException {
        Matcher var3 = IP_ADDRESS_PATTERN.matcher(var1);
        if (var3.matches()) {
            return CommandBanIp.banIp(var0, var1, var2);
        }
        EntityPlayer var4 = var0.getServer().getPlayerList().getPlayerByName(var1);
        if (var4 != null) {
            return CommandBanIp.banIp(var0, var4.getIpAddress(), var2);
        }
        throw ERROR_INVALID_IP.create();
    }

    private static int banIp(CommandListenerWrapper var0, String var1, @Nullable IChatBaseComponent var2) throws CommandSyntaxException {
        IpBanList var3 = var0.getServer().getPlayerList().getIpBans();
        if (var3.isBanned(var1)) {
            throw ERROR_ALREADY_BANNED.create();
        }
        List<EntityPlayer> var4 = var0.getServer().getPlayerList().getPlayersWithAddress(var1);
        IpBanEntry var5 = new IpBanEntry(var1, null, var0.getTextName(), null, var2 == null ? null : var2.getString());
        var3.add(var5);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.banip.success", var1, var5.getReason()), true);
        if (!var4.isEmpty()) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.banip.info", var4.size(), EntitySelector.joinNames(var4)), true);
        }
        for (EntityPlayer var7 : var4) {
            var7.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.ip_banned"));
        }
        return var4.size();
    }
}

