/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.UUID;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class CommandAttribute {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.attribute.failed.entity", var0));
    private static final Dynamic2CommandExceptionType ERROR_NO_SUCH_ATTRIBUTE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("commands.attribute.failed.no_attribute", var0, var1));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.translatable("commands.attribute.failed.no_modifier", var1, var0, var2));
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.translatable("commands.attribute.failed.modifier_already_present", var2, var1, var0));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("attribute").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.entity()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("attribute", ResourceKeyArgument.key(IRegistry.ATTRIBUTE_REGISTRY)).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("get").executes(var0 -> CommandAttribute.getAttributeValue((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).executes(var0 -> CommandAttribute.getAttributeValue((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"scale")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("base").then(net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.argument("value", DoubleArgumentType.doubleArg()).executes(var0 -> CommandAttribute.setAttributeBase((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"value")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("get").executes(var0 -> CommandAttribute.getAttributeBase((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).executes(var0 -> CommandAttribute.getAttributeBase((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"scale"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("modifier").then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("uuid", ArgumentUUID.uuid()).then(net.minecraft.commands.CommandDispatcher.argument("name", StringArgumentType.string()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("value", DoubleArgumentType.doubleArg()).then(net.minecraft.commands.CommandDispatcher.literal("add").executes(var0 -> CommandAttribute.addModifier((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "uuid"), StringArgumentType.getString((CommandContext)var0, (String)"name"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"value"), AttributeModifier.Operation.ADDITION)))).then(net.minecraft.commands.CommandDispatcher.literal("multiply").executes(var0 -> CommandAttribute.addModifier((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "uuid"), StringArgumentType.getString((CommandContext)var0, (String)"name"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"value"), AttributeModifier.Operation.MULTIPLY_TOTAL)))).then(net.minecraft.commands.CommandDispatcher.literal("multiply_base").executes(var0 -> CommandAttribute.addModifier((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "uuid"), StringArgumentType.getString((CommandContext)var0, (String)"name"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"value"), AttributeModifier.Operation.MULTIPLY_BASE)))))))).then(net.minecraft.commands.CommandDispatcher.literal("remove").then(net.minecraft.commands.CommandDispatcher.argument("uuid", ArgumentUUID.uuid()).executes(var0 -> CommandAttribute.removeModifier((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "uuid")))))).then(net.minecraft.commands.CommandDispatcher.literal("value").then(net.minecraft.commands.CommandDispatcher.literal("get").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("uuid", ArgumentUUID.uuid()).executes(var0 -> CommandAttribute.getAttributeModifier((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "uuid"), 1.0))).then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).executes(var0 -> CommandAttribute.getAttributeModifier((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandListenerWrapper>)var0, "attribute"), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "uuid"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"scale")))))))))));
    }

    private static AttributeModifiable getAttributeInstance(Entity var0, AttributeBase var1) throws CommandSyntaxException {
        AttributeModifiable var2 = CommandAttribute.getLivingEntity(var0).getAttributes().getInstance(var1);
        if (var2 == null) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)var0.getName(), (Object)IChatBaseComponent.translatable(var1.getDescriptionId()));
        }
        return var2;
    }

    private static EntityLiving getLivingEntity(Entity var0) throws CommandSyntaxException {
        if (!(var0 instanceof EntityLiving)) {
            throw ERROR_NOT_LIVING_ENTITY.create((Object)var0.getName());
        }
        return (EntityLiving)var0;
    }

    private static EntityLiving getEntityWithAttribute(Entity var0, AttributeBase var1) throws CommandSyntaxException {
        EntityLiving var2 = CommandAttribute.getLivingEntity(var0);
        if (!var2.getAttributes().hasAttribute(var1)) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)var0.getName(), (Object)IChatBaseComponent.translatable(var1.getDescriptionId()));
        }
        return var2;
    }

    private static int getAttributeValue(CommandListenerWrapper var0, Entity var1, AttributeBase var2, double var3) throws CommandSyntaxException {
        EntityLiving var5 = CommandAttribute.getEntityWithAttribute(var1, var2);
        double var6 = var5.getAttributeValue(var2);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.attribute.value.get.success", IChatBaseComponent.translatable(var2.getDescriptionId()), var1.getName(), var6), false);
        return (int)(var6 * var3);
    }

    private static int getAttributeBase(CommandListenerWrapper var0, Entity var1, AttributeBase var2, double var3) throws CommandSyntaxException {
        EntityLiving var5 = CommandAttribute.getEntityWithAttribute(var1, var2);
        double var6 = var5.getAttributeBaseValue(var2);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.attribute.base_value.get.success", IChatBaseComponent.translatable(var2.getDescriptionId()), var1.getName(), var6), false);
        return (int)(var6 * var3);
    }

    private static int getAttributeModifier(CommandListenerWrapper var0, Entity var1, AttributeBase var2, UUID var3, double var4) throws CommandSyntaxException {
        EntityLiving var6 = CommandAttribute.getEntityWithAttribute(var1, var2);
        AttributeMapBase var7 = var6.getAttributes();
        if (!var7.hasModifier(var2, var3)) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)var1.getName(), (Object)IChatBaseComponent.translatable(var2.getDescriptionId()), (Object)var3);
        }
        double var8 = var7.getModifierValue(var2, var3);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.attribute.modifier.value.get.success", var3, IChatBaseComponent.translatable(var2.getDescriptionId()), var1.getName(), var8), false);
        return (int)(var8 * var4);
    }

    private static int setAttributeBase(CommandListenerWrapper var0, Entity var1, AttributeBase var2, double var3) throws CommandSyntaxException {
        CommandAttribute.getAttributeInstance(var1, var2).setBaseValue(var3);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.attribute.base_value.set.success", IChatBaseComponent.translatable(var2.getDescriptionId()), var1.getName(), var3), false);
        return 1;
    }

    private static int addModifier(CommandListenerWrapper var0, Entity var1, AttributeBase var2, UUID var3, String var4, double var5, AttributeModifier.Operation var7) throws CommandSyntaxException {
        AttributeModifier var9;
        AttributeModifiable var8 = CommandAttribute.getAttributeInstance(var1, var2);
        if (var8.hasModifier(var9 = new AttributeModifier(var3, var4, var5, var7))) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)var1.getName(), (Object)IChatBaseComponent.translatable(var2.getDescriptionId()), (Object)var3);
        }
        var8.addPermanentModifier(var9);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.attribute.modifier.add.success", var3, IChatBaseComponent.translatable(var2.getDescriptionId()), var1.getName()), false);
        return 1;
    }

    private static int removeModifier(CommandListenerWrapper var0, Entity var1, AttributeBase var2, UUID var3) throws CommandSyntaxException {
        AttributeModifiable var4 = CommandAttribute.getAttributeInstance(var1, var2);
        if (var4.removePermanentModifier(var3)) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.attribute.modifier.remove.success", var3, IChatBaseComponent.translatable(var2.getDescriptionId()), var1.getName()), false);
            return 1;
        }
        throw ERROR_NO_SUCH_MODIFIER.create((Object)var1.getName(), (Object)IChatBaseComponent.translatable(var2.getDescriptionId()), (Object)var3);
    }
}

