/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResourceManager;
import org.slf4j.Logger;

public interface RegistryResourceAccess {
    public <E> Map<ResourceKey<E>, a<E>> listResources(ResourceKey<? extends IRegistry<E>> var1);

    public <E> Optional<a<E>> getResource(ResourceKey<E> var1);

    public static RegistryResourceAccess forResourceManager(final IResourceManager var0) {
        return new RegistryResourceAccess(){
            private static final String JSON = ".json";

            @Override
            public <E> Map<ResourceKey<E>, a<E>> listResources(ResourceKey<? extends IRegistry<E>> var02) {
                String var1 = 1.registryDirPath(var02.location());
                HashMap var2 = Maps.newHashMap();
                var0.listResources(var1, var0 -> var0.getPath().endsWith(JSON)).forEach((var32, var4) -> {
                    String var5 = var32.getPath();
                    String var6 = var5.substring(var1.length() + 1, var5.length() - JSON.length());
                    ResourceKey var7 = ResourceKey.create(var02, new MinecraftKey(var32.getNamespace(), var6));
                    var2.put(var7, (var2, var3) -> {
                        DataResult dataResult;
                        block8: {
                            Object var4 = var4.openAsReader();
                            try {
                                dataResult = this.decodeElement((DynamicOps<JsonElement>)var2, (Decoder)var3, (Reader)var4);
                                if (var4 == null) break block8;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (var4 != null) {
                                        try {
                                            ((Reader)var4).close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (JsonIOException | JsonSyntaxException | IOException var42) {
                                    return DataResult.error((String)("Failed to parse " + var32 + " file: " + var42.getMessage()));
                                }
                            }
                            ((Reader)var4).close();
                        }
                        return dataResult;
                    });
                });
                return var2;
            }

            @Override
            public <E> Optional<a<E>> getResource(ResourceKey<E> var02) {
                MinecraftKey var12 = 1.elementPath(var02);
                return var0.getResource(var12).map(var1 -> (var2, var3) -> {
                    DataResult dataResult;
                    block8: {
                        BufferedReader var4 = var1.openAsReader();
                        try {
                            dataResult = this.decodeElement((DynamicOps<JsonElement>)var2, var3, var4);
                            if (var4 == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (var4 != null) {
                                    try {
                                        ((Reader)var4).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (JsonIOException | JsonSyntaxException | IOException var42) {
                                return DataResult.error((String)("Failed to parse " + var12 + " file: " + var42.getMessage()));
                            }
                        }
                        ((Reader)var4).close();
                    }
                    return dataResult;
                });
            }

            private <E> DataResult<ParsedEntry<E>> decodeElement(DynamicOps<JsonElement> var02, Decoder<E> var1, Reader var2) throws IOException {
                JsonElement var3 = JsonParser.parseReader((Reader)var2);
                return var1.parse(var02, (Object)var3).map(ParsedEntry::createWithoutId);
            }

            private static String registryDirPath(MinecraftKey var02) {
                return var02.getPath();
            }

            private static <E> MinecraftKey elementPath(ResourceKey<E> var02) {
                return new MinecraftKey(var02.location().getNamespace(), 1.registryDirPath(var02.registry()) + "/" + var02.location().getPath() + JSON);
            }

            public String toString() {
                return "ResourceAccess[" + var0 + "]";
            }
        };
    }

    public static final class InMemoryStorage
    implements RegistryResourceAccess {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final Map<ResourceKey<?>, Entry> entries = Maps.newIdentityHashMap();

        public <E> void add(IRegistryCustom var0, ResourceKey<E> var1, Encoder<E> var2, int var3, E var4, Lifecycle var5) {
            DataResult var6 = var2.encodeStart(RegistryOps.create(JsonOps.INSTANCE, var0), var4);
            Optional var7 = var6.error();
            if (var7.isPresent()) {
                LOGGER.error("Error adding element: {}", (Object)((DataResult.PartialResult)var7.get()).message());
            } else {
                this.entries.put(var1, new Entry((JsonElement)var6.result().get(), var3, var5));
            }
        }

        @Override
        public <E> Map<ResourceKey<E>, a<E>> listResources(ResourceKey<? extends IRegistry<E>> var02) {
            return this.entries.entrySet().stream().filter(var1 -> ((ResourceKey)var1.getKey()).isFor(var02)).collect(Collectors.toMap(var0 -> (ResourceKey)var0.getKey(), var0 -> ((Entry)var0.getValue())::parse));
        }

        @Override
        public <E> Optional<a<E>> getResource(ResourceKey<E> var0) {
            Entry var12 = this.entries.get(var0);
            if (var12 == null) {
                DataResult var22 = DataResult.error((String)("Unknown element: " + var0));
                return Optional.of((var1, var2) -> var22);
            }
            return Optional.of(var12::parse);
        }

        record Entry(JsonElement data, int id, Lifecycle lifecycle) {
            public <E> DataResult<ParsedEntry<E>> parse(DynamicOps<JsonElement> var02, Decoder<E> var1) {
                return var1.parse(var02, (Object)this.data).setLifecycle(this.lifecycle).map(var0 -> ParsedEntry.createWithId(var0, this.id));
            }
        }
    }

    @FunctionalInterface
    public static interface a<E> {
        public DataResult<ParsedEntry<E>> parseElement(DynamicOps<JsonElement> var1, Decoder<E> var2);
    }

    public record ParsedEntry<E>(E value, OptionalInt fixedId) {
        public static <E> ParsedEntry<E> createWithoutId(E var0) {
            return new ParsedEntry<E>(var0, OptionalInt.empty());
        }

        public static <E> ParsedEntry<E> createWithId(E var0, int var1) {
            return new ParsedEntry<E>(var0, OptionalInt.of(var1));
        }
    }
}

