/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.resources.MinecraftKey;

public class PacketLoginOutCustomPayload
implements Packet<PacketLoginOutListener> {
    private static final int MAX_PAYLOAD_SIZE = 0x100000;
    private final int transactionId;
    private final MinecraftKey identifier;
    private final PacketDataSerializer data;

    public PacketLoginOutCustomPayload(int var0, MinecraftKey var1, PacketDataSerializer var2) {
        this.transactionId = var0;
        this.identifier = var1;
        this.data = var2;
    }

    public PacketLoginOutCustomPayload(PacketDataSerializer var0) {
        this.transactionId = var0.readVarInt();
        this.identifier = var0.readResourceLocation();
        int var1 = var0.readableBytes();
        if (var1 < 0 || var1 > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
        this.data = new PacketDataSerializer(var0.readBytes(var1));
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.transactionId);
        var0.writeResourceLocation(this.identifier);
        var0.writeBytes(this.data.copy());
    }

    @Override
    public void handle(PacketLoginOutListener var0) {
        var0.handleCustomQuery(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public MinecraftKey getIdentifier() {
        return this.identifier;
    }

    public PacketDataSerializer getData() {
        return this.data;
    }
}

