/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import com.mojang.datafixers.util.Either;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Optional;
import javax.crypto.SecretKey;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.entity.player.ProfilePublicKey;

public class PacketLoginInEncryptionBegin
implements Packet<PacketLoginInListener> {
    private final byte[] keybytes;
    private final Either<byte[], MinecraftEncryption.b> nonceOrSaltSignature;

    public PacketLoginInEncryptionBegin(SecretKey var0, PublicKey var1, byte[] var2) throws CryptographyException {
        this.keybytes = MinecraftEncryption.encryptUsingKey(var1, var0.getEncoded());
        this.nonceOrSaltSignature = Either.left((Object)MinecraftEncryption.encryptUsingKey(var1, var2));
    }

    public PacketLoginInEncryptionBegin(SecretKey var0, PublicKey var1, long var2, byte[] var4) throws CryptographyException {
        this.keybytes = MinecraftEncryption.encryptUsingKey(var1, var0.getEncoded());
        this.nonceOrSaltSignature = Either.right((Object)new MinecraftEncryption.b(var2, var4));
    }

    public PacketLoginInEncryptionBegin(PacketDataSerializer var0) {
        this.keybytes = var0.readByteArray();
        this.nonceOrSaltSignature = var0.readEither(PacketDataSerializer::readByteArray, MinecraftEncryption.b::new);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeByteArray(this.keybytes);
        var0.writeEither(this.nonceOrSaltSignature, PacketDataSerializer::writeByteArray, MinecraftEncryption.b::write);
    }

    @Override
    public void handle(PacketLoginInListener var0) {
        var0.handleKey(this);
    }

    public SecretKey getSecretKey(PrivateKey var0) throws CryptographyException {
        return MinecraftEncryption.decryptByteToSecretKey(var0, this.keybytes);
    }

    public boolean isChallengeSignatureValid(byte[] var02, ProfilePublicKey var1) {
        return (Boolean)this.nonceOrSaltSignature.map(var0 -> false, var22 -> var1.createSignatureValidator().validate(var2 -> {
            var2.update(var02);
            var2.update(var22.saltAsBytes());
        }, var22.signature()));
    }

    public boolean isNonceValid(byte[] var0, PrivateKey var1) {
        Optional var2 = this.nonceOrSaltSignature.left();
        try {
            return var2.isPresent() && Arrays.equals(var0, MinecraftEncryption.decryptUsingKey(var1, (byte[])var2.get()));
        }
        catch (CryptographyException var3) {
            return false;
        }
    }
}

