/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticWrapper;

public class PacketPlayOutStatistic
implements Packet<PacketListenerPlayOut> {
    private final Object2IntMap<Statistic<?>> stats;

    public PacketPlayOutStatistic(Object2IntMap<Statistic<?>> var0) {
        this.stats = var0;
    }

    public PacketPlayOutStatistic(PacketDataSerializer var0) {
        this.stats = (Object2IntMap)var0.readMap(Object2IntOpenHashMap::new, var1 -> {
            StatisticWrapper<?> var2 = var1.readById(IRegistry.STAT_TYPE);
            return PacketPlayOutStatistic.readStatCap(var0, var2);
        }, PacketDataSerializer::readVarInt);
    }

    private static <T> Statistic<T> readStatCap(PacketDataSerializer var0, StatisticWrapper<T> var1) {
        return var1.get(var0.readById(var1.getRegistry()));
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAwardStats(this);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeMap(this.stats, PacketPlayOutStatistic::writeStatCap, PacketDataSerializer::writeVarInt);
    }

    private static <T> void writeStatCap(PacketDataSerializer var0, Statistic<T> var1) {
        var0.writeId(IRegistry.STAT_TYPE, var1.getType());
        var0.writeId(var1.getType().getRegistry(), var1.getValue());
    }

    public Map<Statistic<?>, Integer> getStats() {
        return this.stats;
    }
}

