/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;

public class PacketPlayOutRespawn
implements Packet<PacketListenerPlayOut> {
    private final ResourceKey<DimensionManager> dimensionType;
    private final ResourceKey<World> dimension;
    private final long seed;
    private final EnumGamemode playerGameType;
    @Nullable
    private final EnumGamemode previousPlayerGameType;
    private final boolean isDebug;
    private final boolean isFlat;
    private final boolean keepAllPlayerData;
    private final Optional<GlobalPos> lastDeathLocation;

    public PacketPlayOutRespawn(ResourceKey<DimensionManager> var0, ResourceKey<World> var1, long var2, EnumGamemode var4, @Nullable EnumGamemode var5, boolean var6, boolean var7, boolean var8, Optional<GlobalPos> var9) {
        this.dimensionType = var0;
        this.dimension = var1;
        this.seed = var2;
        this.playerGameType = var4;
        this.previousPlayerGameType = var5;
        this.isDebug = var6;
        this.isFlat = var7;
        this.keepAllPlayerData = var8;
        this.lastDeathLocation = var9;
    }

    public PacketPlayOutRespawn(PacketDataSerializer var0) {
        this.dimensionType = var0.readResourceKey(IRegistry.DIMENSION_TYPE_REGISTRY);
        this.dimension = var0.readResourceKey(IRegistry.DIMENSION_REGISTRY);
        this.seed = var0.readLong();
        this.playerGameType = EnumGamemode.byId(var0.readUnsignedByte());
        this.previousPlayerGameType = EnumGamemode.byNullableId(var0.readByte());
        this.isDebug = var0.readBoolean();
        this.isFlat = var0.readBoolean();
        this.keepAllPlayerData = var0.readBoolean();
        this.lastDeathLocation = var0.readOptional(PacketDataSerializer::readGlobalPos);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeResourceKey(this.dimensionType);
        var0.writeResourceKey(this.dimension);
        var0.writeLong(this.seed);
        var0.writeByte(this.playerGameType.getId());
        var0.writeByte(EnumGamemode.getNullableId(this.previousPlayerGameType));
        var0.writeBoolean(this.isDebug);
        var0.writeBoolean(this.isFlat);
        var0.writeBoolean(this.keepAllPlayerData);
        var0.writeOptional(this.lastDeathLocation, PacketDataSerializer::writeGlobalPos);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleRespawn(this);
    }

    public ResourceKey<DimensionManager> getDimensionType() {
        return this.dimensionType;
    }

    public ResourceKey<World> getDimension() {
        return this.dimension;
    }

    public long getSeed() {
        return this.seed;
    }

    public EnumGamemode getPlayerGameType() {
        return this.playerGameType;
    }

    @Nullable
    public EnumGamemode getPreviousPlayerGameType() {
        return this.previousPlayerGameType;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public boolean shouldKeepAllPlayerData() {
        return this.keepAllPlayerData;
    }

    public Optional<GlobalPos> getLastDeathLocation() {
        return this.lastDeathLocation;
    }
}

