/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.Validate;

public class PacketPlayOutEntitySound
implements Packet<PacketListenerPlayOut> {
    private final SoundEffect sound;
    private final SoundCategory source;
    private final int id;
    private final float volume;
    private final float pitch;
    private final long seed;

    public PacketPlayOutEntitySound(SoundEffect var0, SoundCategory var1, Entity var2, float var3, float var4, long var5) {
        Validate.notNull((Object)var0, (String)"sound", (Object[])new Object[0]);
        this.sound = var0;
        this.source = var1;
        this.id = var2.getId();
        this.volume = var3;
        this.pitch = var4;
        this.seed = var5;
    }

    public PacketPlayOutEntitySound(PacketDataSerializer var0) {
        this.sound = var0.readById(IRegistry.SOUND_EVENT);
        this.source = var0.readEnum(SoundCategory.class);
        this.id = var0.readVarInt();
        this.volume = var0.readFloat();
        this.pitch = var0.readFloat();
        this.seed = var0.readLong();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeId(IRegistry.SOUND_EVENT, this.sound);
        var0.writeEnum(this.source);
        var0.writeVarInt(this.id);
        var0.writeFloat(this.volume);
        var0.writeFloat(this.pitch);
        var0.writeLong(this.seed);
    }

    public SoundEffect getSound() {
        return this.sound;
    }

    public SoundCategory getSource() {
        return this.source;
    }

    public int getId() {
        return this.id;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getSeed() {
        return this.seed;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSoundEntityEvent(this);
    }
}

