/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageContent;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.LastSeenMessages;

public record SignedMessageBody(ChatMessageContent content, Instant timeStamp, long salt, LastSeenMessages lastSeen) {
    public static final byte HASH_SEPARATOR_BYTE = 70;

    public SignedMessageBody(PacketDataSerializer var0) {
        this(ChatMessageContent.read(var0), var0.readInstant(), var0.readLong(), new LastSeenMessages(var0));
    }

    public void write(PacketDataSerializer var0) {
        ChatMessageContent.write(var0, this.content);
        var0.writeInstant(this.timeStamp);
        var0.writeLong(this.salt);
        this.lastSeen.write(var0);
    }

    public HashCode hash() {
        HashingOutputStream var0 = new HashingOutputStream(Hashing.sha256(), OutputStream.nullOutputStream());
        try {
            DataOutputStream var1 = new DataOutputStream((OutputStream)var0);
            var1.writeLong(this.salt);
            var1.writeLong(this.timeStamp.getEpochSecond());
            OutputStreamWriter var2 = new OutputStreamWriter((OutputStream)var1, StandardCharsets.UTF_8);
            var2.write(this.content.plain());
            var2.flush();
            var1.write(70);
            if (this.content.isDecorated()) {
                var2.write(IChatBaseComponent.ChatSerializer.toStableJson(this.content.decorated()));
                var2.flush();
            }
            this.lastSeen.updateHash(var1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return var0.hash();
    }

    public SignedMessageBody withContent(ChatMessageContent var0) {
        return new SignedMessageBody(var0, this.timeStamp, this.salt, this.lastSeen);
    }
}

