/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageContent;
import net.minecraft.network.chat.ChatSender;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSigner;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageHeader;
import net.minecraft.util.SignatureValidator;
import net.minecraft.world.entity.player.ProfilePublicKey;

public record PlayerChatMessage(SignedMessageHeader signedHeader, MessageSignature headerSignature, SignedMessageBody signedBody, Optional<IChatBaseComponent> unsignedContent, FilterMask filterMask) {
    public static final Duration MESSAGE_EXPIRES_AFTER_SERVER = Duration.ofMinutes(5L);
    public static final Duration MESSAGE_EXPIRES_AFTER_CLIENT = MESSAGE_EXPIRES_AFTER_SERVER.plus(Duration.ofMinutes(2L));

    public PlayerChatMessage(PacketDataSerializer var0) {
        this(new SignedMessageHeader(var0), new MessageSignature(var0), new SignedMessageBody(var0), var0.readOptional(PacketDataSerializer::readComponent), FilterMask.read(var0));
    }

    public static PlayerChatMessage system(ChatMessageContent var0) {
        return PlayerChatMessage.unsigned(MessageSigner.system(), var0);
    }

    public static PlayerChatMessage unsigned(MessageSigner var0, ChatMessageContent var1) {
        SignedMessageBody var2 = new SignedMessageBody(var1, var0.timeStamp(), var0.salt(), LastSeenMessages.EMPTY);
        SignedMessageHeader var3 = new SignedMessageHeader(null, var0.profileId());
        return new PlayerChatMessage(var3, MessageSignature.EMPTY, var2, Optional.empty(), FilterMask.PASS_THROUGH);
    }

    public void write(PacketDataSerializer var0) {
        this.signedHeader.write(var0);
        this.headerSignature.write(var0);
        this.signedBody.write(var0);
        var0.writeOptional(this.unsignedContent, PacketDataSerializer::writeComponent);
        FilterMask.write(var0, this.filterMask);
    }

    public PlayerChatMessage withUnsignedContent(IChatBaseComponent var0) {
        Optional<IChatBaseComponent> var1 = !this.signedContent().decorated().equals(var0) ? Optional.of(var0) : Optional.empty();
        return new PlayerChatMessage(this.signedHeader, this.headerSignature, this.signedBody, var1, this.filterMask);
    }

    public PlayerChatMessage removeUnsignedContent() {
        if (this.unsignedContent.isPresent()) {
            return new PlayerChatMessage(this.signedHeader, this.headerSignature, this.signedBody, Optional.empty(), this.filterMask);
        }
        return this;
    }

    public PlayerChatMessage filter(FilterMask var0) {
        if (this.filterMask.equals(var0)) {
            return this;
        }
        return new PlayerChatMessage(this.signedHeader, this.headerSignature, this.signedBody, this.unsignedContent, var0);
    }

    public PlayerChatMessage filter(boolean var0) {
        return this.filter(var0 ? this.filterMask : FilterMask.PASS_THROUGH);
    }

    public boolean verify(SignatureValidator var0) {
        return this.headerSignature.verify(var0, this.signedHeader, this.signedBody);
    }

    public boolean verify(ProfilePublicKey var0) {
        SignatureValidator var1 = var0.createSignatureValidator();
        return this.verify(var1);
    }

    public boolean verify(ChatSender var0) {
        ProfilePublicKey var1 = var0.profilePublicKey();
        return var1 != null && this.verify(var1);
    }

    public ChatMessageContent signedContent() {
        return this.signedBody.content();
    }

    public IChatBaseComponent serverContent() {
        return this.unsignedContent().orElse(this.signedContent().decorated());
    }

    public Instant timeStamp() {
        return this.signedBody.timeStamp();
    }

    public long salt() {
        return this.signedBody.salt();
    }

    public boolean hasExpiredServer(Instant var0) {
        return var0.isAfter(this.timeStamp().plus(MESSAGE_EXPIRES_AFTER_SERVER));
    }

    public boolean hasExpiredClient(Instant var0) {
        return var0.isAfter(this.timeStamp().plus(MESSAGE_EXPIRES_AFTER_CLIENT));
    }

    public MessageSigner signer() {
        return new MessageSigner(this.signedHeader.sender(), this.timeStamp(), this.salt());
    }

    @Nullable
    public LastSeenMessages.a toLastSeenEntry() {
        MessageSigner var0 = this.signer();
        if (!this.headerSignature.isEmpty() && !var0.isSystem()) {
            return new LastSeenMessages.a(var0.profileId(), this.headerSignature);
        }
        return null;
    }

    public boolean hasSignatureFrom(UUID var0) {
        return !this.headerSignature.isEmpty() && this.signedHeader.sender().equals(var0);
    }

    public boolean isFullyFiltered() {
        return this.filterMask.isFullyFiltered();
    }
}

